// Revision: 87 1.6.2.1 source/albert/graph2d/ibmpdata.inl, 2d, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IBMPDATA_INL_
#define _IBMPDATA_INL_
/*******************************************************************************
* FILE NAME: ibmpdata.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ibmpdata.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

inline unsigned long IBitmapData::addRef( )
{
  return (++fUseCount);
}

inline unsigned long IBitmapData::removeRef( )
{
  return (--fUseCount);
}

inline unsigned long IBitmapData::useCount( ) const
{
  return fUseCount;
}

inline unsigned long IBitmapData::id( ) const
{
  return fResourceId;
}

inline IBitmapHandle::Value IBitmapData::handle( ) const
{
  return (IBitmapHandle::Value)fHandle;
}

inline IBitmapData& IBitmapData::setHandle( IBitmapHandle::Value handle )
{
  fHandle = (unsigned long)handle;
  return *this;
}

inline IBitmapData& IBitmapData::setSize( const ISize& newSize )
{
  fBitmapSize = newSize;
  return *this;
}


inline IString IBitmapData::resourceFileName( ) const
{
  return fResourceFileName;
}

inline ISize IBitmapData::size( ) const
{
  return fBitmapSize;
}

inline bool IBitmapData::operator ==(const IBitmapData& bmpData ) const
{
  if( (bmpData.id() == this->id()) &&
      (bmpData.size() == this->size()) &&
      (bmpData.resourceFileName() == this->resourceFileName()) )
       return(1);
  else
       return(0);
}


#ifdef IC_MOTIF
inline IBitmapData& IBitmapData::setImage( _XImage* image )
{
  fImage = image;
  return *this;
}


inline IBitmapData& IBitmapData::setImageSize( const ISize& imageSize )
{
  fImageSize = imageSize;
  return *this;
}

inline _XImage* IBitmapData::image ( ) const
{ 
  return fImage; 
}


inline ISize IBitmapData::imageSize ( ) const     
{ 
  return fImageSize; 
} 

 
#endif  // IC_MOTIF


inline IPixelBuffer* IBitmapData::pixelBuffer( )
{
  return fPixBuf;
}  



inline IPointerData::operator ==(const IPointerData& ptr) const
{
  if( (ptr.id() == this->id()) &&
       (ptr.resourceFileName() == this->resourceFileName())
    )
     return(1);
  else
     return(0);
}

inline IPoint IPointerData::hotSpot ( ) const
{  
  return fHotSpot; 
}



inline unsigned long const& key (IBitmapData* const& bitmapData)
{
  return bitmapData->fHandle;
}

inline unsigned long const& key (IPointerData* const& pointerData)
{
  return pointerData->fHandle;
}


#ifdef IC_MOTIF
inline unsigned long IPointerData::maskPixmap ( ) const     
{
  return fMaskPixmap; 
}

inline _XImage* IPointerData::maskImage ( ) const
{  
  return fMaskImage; 
}

#endif  // IC_MOTIF


#endif // _IBMPDATA_INL_
