// Revision: 86 1.10.2.3 source/albert/graph2d/ibmpdata.hpp, 2d, ioc.v400, 001006 
/* NOSHIP */
#ifndef _IBMPDATA_
#define _IBMPDATA_
/*******************************************************************************
* FILE NAME: ibmpdata.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBitmapData                                                              *
*     IBitmapSet                                                               *
*     IPointerData                                                             *
*     IPointerSet                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <igraphpl.hpp>
#include <istring.hpp>
#include <i2dghand.hpp>
#include <ipoint.hpp>
#include <ikeyset2.h>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

struct _XImage;
class IPixelBuffer;
class IBitmapData;
class IPointerData;

#ifndef IC_BUILD
inline unsigned long const &key(IBitmapData* const& bitmapData);
inline unsigned long const &key(IPointerData* const& pointerData);
#endif

#pragma enum(4)
#pragma pack(push,4)

class IBitmapData  {
/*******************************************************************************
* The IBitmapData class provides reference counting mechanism for              *
* the IBitmapHandle class.  This class contains the bitmap handle, the         *
* bitmap resource id, the file from which the bitmap was loaded, and the       *
* size of the bitmap. On Motif, it also contains the XImage used to create     *
* the pixmap represented by the IBitmapHandle.                                 *
*******************************************************************************/
public:
/*------------------------- Constructors/Destructor ----------------------------
| There are two ways to construct an IBitmapData object.                       |
|                                                                              |
| You can construct an IBitmapData object from its resource id, the bitmap     |
| handle, the file from which the bitmap was loaded and optionally the         |
| size of the bitmap.  If the size is not passed on the ctor, then the         |
| size defaults to 0,0 (which is interpreted to mean, don't size the image).   |
| On Motif, you need to provide the XImage used to construct the pixmap. For   |
| backwards compatibility, this class also supports creation from an xpm file. |
------------------------------------------------------------------------------*/
#ifdef IC_PMWIN
   // Load a PM/Windows bitmap from a resource file.
   IBitmapData( unsigned long         resourceId,
                IBitmapHandle::Value  bitmapHandle,
                const IString&        resourceFileName,
                const ISize&          bitmapSize = ISize(0,0),
                IPixelBuffer*         pixelBuffer=0);
#ifdef IC_WIN
 #ifndef IC_WIN_STRICT
// The implementation of this function in ibmdata.cpp is always
// compiled with STRICT. For the case where the caller is compiled
// with NO_STRICT, map this function name to its STRICT version to
// avoid errors at link time.
  #pragma map( IBitmapData::IBitmapData(unsigned long,void*,const IString&,const ISize&,IPixelBuffer*), "?__ct__11IBitmapDataFUlP9HBITMAP__RC7IStringRC5ISizeP12IPixelBuffer" )
 #endif
#endif // IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF
   // Load a Motif bitmap from resources in the executable
   IBitmapData(unsigned long  resourceId,
               const IString& resourceFileName,
               const ISize&   xImageSize,
               const ISize&   bitmapSize,
               _XImage*       xImage,
               IPixelBuffer*  pixelBuffer=0);

   IBitmapData(unsigned long  resourceId,
               const ISize&   xImageSize,
               _XImage*       xImage,
               unsigned long  pixmap,
               IPixelBuffer*  pixelBuffer=0);

#endif // IC_MOTIF

virtual ~IBitmapData();

/*-------------------------------- Accessors -----------------------------------
| addRef           - Increment the use count and return the current use count. |
| removeRef        - Decrement the use count and return the current use count. |
| useCount         - Return the current use count.                             |
| id               - return the resource id for the bitmap.                    |
| handle           - return the bitmap handle.                                 |
| setHandle        - Replace the current handle with the new handle.           |
| setSize          - Replace the current size with the new size.               |
| resourceFileName - Return the name of the file from which the bitmap was     |
|                     loaded.                                                  |
| size             - Return the size of the bitmap.  This man not reflect      |
|                    the actual size of the bitmap.                            |
------------------------------------------------------------------------------*/
unsigned long
  addRef           ( ),
  removeRef        ( ),
  useCount         ( ) const,
  id               ( ) const;

IBitmapHandle::Value
  handle           ( ) const;

IBitmapData
 &setHandle        ( IBitmapHandle::Value handle ),
 &setSize          ( const ISize&         size   );

IString
  resourceFileName ( ) const;
ISize
  size             ( ) const;


void adoptPixelBuffer      ( IPixelBuffer* pixelBuffer);

IPixelBuffer
 *pixelBuffer         ( );

/*--------------------------- Comparison Operators -----------------------------
| operator == - Returns true if the id size and resource file names are        |
|               identical.                                                     |
------------------------------------------------------------------------------*/
bool operator ==(const IBitmapData& bmpData ) const;

#ifdef IC_MOTIF
_XImage*
  image       ( ) const;
ISize
  imageSize   ( ) const;

// An insensitive pixmap is a stippled image that is used
// when an "inactive" image is needed.
unsigned long
  insensitivePixmap();

  #if 1 // RDL for backwards compatibility
    ISize
      trueSize    ( ) const { return fImageSize;}
  #endif
#endif // IC_MOTIF

protected:
#ifdef IC_MOTIF
IBitmapData
 &setImage     ( _XImage* image),
 &setImageSize ( const ISize& size);

void
  createPixmapFromImage ( );

unsigned long
  createInsensitivePixmap  ( );

_XImage
  *copyImage           ( _XImage*     source,
                         const ISize& sizeBitmap);
_XImage*
  createXImage          ( const ISize& size,
                          unsigned long depth);

#endif  // IC_MOTIF

// protected so that IPointerSet's key function can
// access it.
unsigned long fHandle;           // Device-dependent image (pixmap on X)

private:

  unsigned long fResourceId;
  IString       fResourceFileName;
  ISize         fBitmapSize;       // Size of device-dependent image
  unsigned long fUseCount;
  IPixelBuffer* fPixBuf;


#ifdef IC_MOTIF
  ISize         fImageSize;        // Size of device-independent image
  _XImage*      fImage;            // Device-independent image
  unsigned long fInsensitivePixmap;
#endif // IC_MOTIF


friend unsigned long const
 &key ( IBitmapData* const& bitmapData );

};



class IBitmapSet : public  IVPtrKeySet<IBitmapData*, unsigned long>
{
/*******************************************************************************
* The IBitmapSet is a set of pointers to IBitmapData objects.  There is only   *
* one such set per process pointed to by a static data member in IReslibStatic *
*******************************************************************************/
public:
/*------------------------- Constructors/Destructor ----------------------------
| Objects of this class must be created using the default constructor.         |
------------------------------------------------------------------------------*/
  IBitmapSet();
  ~IBitmapSet();
/*-------------------------------- Accessors -----------------------------------
------------------------------------------------------------------------------*/
  IBitmapData* find( const unsigned long  bitmapId,
                     const IString&       fileName,
                     const ISize&         sizeBitmap );
  IBitmapData* find( const IBitmapHandle& bitmapHandle );
  IBitmapData* find( IBitmapHandle::Value bitmapHandle );
#ifdef IC_WIN
 #ifndef IC_WIN_STRICT
// The implementation of this function in ibmdata.cpp is always
// compiled with STRICT. For the case where the caller is compiled
// with NO_STRICT, map this function name to its STRICT version to
// avoid errors at link time.
  #pragma map( IBitmapData::find(void*), "?find__10IBitmapSetFP9HBITMAP__" )
 #endif
#endif // IC_WIN
  IBitmapData* find( const IString&       fileName  );
  IBitmapSet&  remove( IBitmapData*       bitmapData );
};

/* Class to represent the real Icon  */
class  IPointerData : public IBitmapData
{
typedef IBitmapData
  Inherited;

public:

#ifdef IC_PMWIN
 IPointerData(unsigned long          resourceId,
              IPointerHandle::Value  pointerHandle,
              const IString&         resourceFileName,
              IPixelBuffer*          pixelBuffer=0);
#ifdef IC_WIN
 #ifndef IC_WIN_STRICT
// The implementation of this function in ibmdata.cpp is always
// compiled with STRICT. For the case where the caller is compiled
// with NO_STRICT, map this function name to its STRICT version to
// avoid errors at link time.
  #pragma map( IPointerData::IPointerData(unsigned long,void*,const IString&,IPixelBuffer*), "?__ct__12IPointerDataFUlFP7HICON__RC7IStringP12IPixelBuffer" )
 #endif
#endif // IC_WIN
#endif // IC_PMWIN

#ifdef IC_MOTIF
 IPointerData(unsigned long  resourceId,
              const IString& resourceFileName,
              const ISize&   imageSize,
              const ISize&   desiredPointerSize,
              _XImage*       image,
              _XImage*       maskImage,
              const IPoint&  hotSpot = IPoint(0,0),
              IPixelBuffer*  pixelBuffer=0);

 // Load a Motif bitmap with transparency from an xpm file.
 IPointerData(unsigned long  resourceId,
             const IString& xpmFileName,
             const ISize&   bitmapSize,
             IPixelBuffer*  pixelBuffer=0);
#endif // IC_MOTIF

virtual ~IPointerData();

IPoint
  hotSpot ( ) const;

operator ==(const IPointerData& ptr) const;

#ifdef IC_MOTIF
unsigned long
  maskPixmap   ( ) const;
_XImage*
  maskImage    ( ) const;
#endif // IC_MOTIF

protected:

#ifdef IC_MOTIF
void
  loadXpmImageFile      ( const IString& xpmFileName,
                          ISize&         imageSize,
                          _XImage**      image,
                          _XImage**      maskImage,
                          IPoint&         hotSpot);
void
  createMaskPixmapFromImage ( );
#endif

private:
  IPoint        fHotSpot;
#ifdef IC_MOTIF
  _XImage*      fMaskImage;
  unsigned long fMaskPixmap;
  IString       fXpmFileName;
#endif // IC_MOTIF


friend unsigned long const
 &key ( IPointerData* const& pointerData );
};


// Internal set for reference counting
class IPointerSet : public IVPtrKeySet<IPointerData*, unsigned long>
{
public:
  IPointerSet( );
 ~IPointerSet( );
 IPointerData* find( IPointerHandle::Value pointerHandle );
#ifdef IC_WIN
 #ifndef IC_WIN_STRICT
// The implementation of this function in ibmdata.cpp is always
// compiled with STRICT. For the case where the caller is compiled
// with NO_STRICT, map this function name to its STRICT version to
// avoid errors at link time.
  #pragma map( IPointerSet::find(void*), "?find__11IPointerSetFP7HICON__" )
 #endif
#endif // IC_WIN
 IPointerSet&  remove( IPointerData*       pointerData );
};



#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ibmpdata.inl>

#endif // _IBMPDATA_
