// Revision: 58 1.1 source/albert/graph2d/i2dghaws.cpp, 2d, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: i2dghaws.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the IC_WIN_STRICT_HANDLES implementation of             *
*   classes/functions declared in i2dghand.hpp (Windows only).                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifdef IC_WIN
// This is the "strict" version of i2dghand.cpp. The implementations
// of the constructors here need to stay in sync with the logic of those
// in i2dghawn.cpp. This file allow applications that build with
// IC_WIN_STRICT_HANDLES to resolve calls to the HBITMAP__* and HICON__*
// version of these constructors at link time.

#ifdef NO_STRICT
  #undef NO_STRICT
#endif
#define STRICT
#define IC_WIN_STRICT_HANDLES
// The above causes IC_WIN_STRICT_HANDLES to be defined, resulting
// in non-void* versions of the following constructors.

#include <i2dghand.hpp>
#include <ibmpstat.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
#define _I2DGHANV_CPP_
#include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IBitmapHandle::IBitmapHandle ( struct HBITMAP__* )                           |
------------------------------------------------------------------------------*/
IBitmapHandle::IBitmapHandle ( Value value )
  : fhandle( value )
{
  if ( fhandle != 0 )
  {
     IBitmapStaticPtr::addBitmapRef( fhandle );
  }
}

/*------------------------------------------------------------------------------
| IPointerHandle::IPointerHandle ( struct HICON__* )                           |
------------------------------------------------------------------------------*/
IPointerHandle::IPointerHandle ( Value value )
  : fhandle( value )
{
  if ( fhandle != 0 )
  {
     IBitmapStaticPtr::addPointerRef( fhandle );
  }
}

#endif // IC_WIN
