// Revision: 57 1.2 source/albert/graph2d/i2dghawn.cpp, 2d, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: i2dghawn.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the NO_STRICT implementation of classes/functions       *
*   declared in i2dghand.hpp (Windows only).                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifdef IC_WIN
// This is the "no strict" version of i2dghand.cpp. The implementations
// of the constructors here need to stay in sync with the logic of those
// in i2dghaws.cpp. This file allows applications that build with
// NO_STRICT (and also with STRICT but without IC_WIN_STRICT_HANDLES) to
// resolve calls to the void* version of these constructors at link time.

#define NO_STRICT
#ifdef STRICT
  #undef STRICT
#endif
// The above causes IC_WIN_STRICT to *not* be defined, resulting
// in void* versions of the following constructors.

#include <i2dghand.hpp>
#include <ibmpstat.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
#define _I2DGHANV_CPP_
#include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IBitmapHandle::IBitmapHandle ( void* )                                       |
------------------------------------------------------------------------------*/
IBitmapHandle::IBitmapHandle ( Value value )
  : fhandle( value )
{
  if ( fhandle != 0 )
  {
     IBitmapStaticPtr::addBitmapRef( fhandle );
  }
}

/*------------------------------------------------------------------------------
| IPointerHandle::IPointerHandle ( void* )                                     |
------------------------------------------------------------------------------*/
IPointerHandle::IPointerHandle ( Value value )
  : fhandle( value )
{
  if ( fhandle != 0 )
  {
     IBitmapStaticPtr::addPointerRef( fhandle );
  }
}

#endif // IC_WIN
