/**
 * FILE NAME: i2dghand.hpp
 *
 * DESCRIPTION:
 *   Declaration of the classes:
 *     INativeWindowHandle
 *     IPointerHandle
 *     IPresSpaceHandle
 *     IBitmapHandle
 *     IRegionHandle
 *
 *   IBM Open Class Library
 *   (C) Copyright International Business Machines Corporation,  1997
 *   Licensed Material - Program-Property of IBM - All Rights Reserved.
 */

// Revision: 66 1.14.2.1 source/albert/graph2d/i2dghand.hpp, 2d, ioc.v400, 001006 

#ifndef _I2DGHAND_
#define _I2DGHAND_

#include <ibase.hpp>
#include <ibhandle.hpp>
#include <igraphpl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifdef IC_MOTIF
class IXDC;
struct _WidgetRec;
typedef _WidgetRec* INativeWindowHandle;
#endif
#ifdef IC_PM
typedef unsigned long INativeWindowHandle;
#endif
#ifdef IC_WIN
struct HBITMAP__;
struct HDC__;
struct HICON__;
struct HRGN__;
struct HWND__;

#ifdef IC_WIN_STRICT
typedef HWND__* INativeWindowHandle;
#else
typedef void* INativeWindowHandle;
#endif
#endif // IC_WIN

#pragma pack(push,4)
#pragma enum(4)

class IPointerHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef unsigned long Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
typedef HICON__* Value;
 #else
typedef void* Value;
 #endif
#endif

/*------------------------------- Constructors -------------------------------*/
#ifdef IC_MOTIFPM
  IPointerHandle ( Value value=0 );
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
  IPointerHandle ( Value value = 0 );
  #else
  IPointerHandle ( void* value = 0 );
  #endif
 #else
  IPointerHandle ( Value value = 0 );
 #endif
#endif // IC_WIN
  IPointerHandle ( const IPointerHandle& aHandle );
 ~IPointerHandle ( );

IPointerHandle
 &operator =     ( const IPointerHandle& aHandle );

/*------------------------------- Diagnostics --------------------------------*/
IString
  asString    ( ) const,
  asDebugInfo ( ) const;

#if 0 // -- Removing these for making it runtime neutral
friend ostream
 &operator << ( ostream&       aStream,
                const IPointerHandle& aHandle );
#endif

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

protected:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IPointerHandle


class IPresSpaceHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef IXDC* Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
typedef HDC__* Value;
 #else
typedef void* Value;
 #endif
#endif // IC_WIN

/*------------------------------- Constructors -------------------------------*/
#ifdef IC_MOTIFPM
  IPresSpaceHandle ( Value value=0, INativeWindowHandle hwnd=0 );
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
  IPresSpaceHandle ( Value               value = 0,
                     INativeWindowHandle hwnd  = 0 );
  #else
  IPresSpaceHandle ( void*               value = 0,
                     INativeWindowHandle hwnd  = 0 );
  #endif
 #else
  IPresSpaceHandle ( Value               value = 0,
                     INativeWindowHandle hwnd  = 0 );
 #endif
#endif // IC_WIN

  IPresSpaceHandle (const IPresSpaceHandle& src);
  IPresSpaceHandle& operator= (const IPresSpaceHandle& src);
 ~IPresSpaceHandle ();

/*------------------------------- Diagnostics --------------------------------*/

IString
  asString    ( ) const,
  asDebugInfo ( ) const;

#if 0 // -- Removing these for making it runtime neutral
friend ostream
 &operator << ( ostream&       aStream,
                const IPresSpaceHandle& aHandle );
#endif

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_PM
friend INativeWindowHandle WindowFromDC(const IPresSpaceHandle&);
#endif
Value
  fhandle;
}; // IPresSpaceHandle

class IBitmapHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef unsigned long Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
typedef HBITMAP__* Value;
 #else
typedef void* Value;
 #endif
#endif

/*------------------------------- Constructors -------------------------------*/
#ifdef IC_MOTIFPM
  IBitmapHandle ( Value value=0 );
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
  IBitmapHandle ( Value value = 0 );
  #else
  IBitmapHandle ( void* value = 0 );
  #endif
 #else
  IBitmapHandle ( Value value = 0 );
 #endif
#endif // IC_WIN
  IBitmapHandle ( const IBitmapHandle& aHandle );
 ~IBitmapHandle ( );

IBitmapHandle
 &operator =    ( const IBitmapHandle& aHandle );

/*------------------------------- Diagnostics --------------------------------*/
IString
  asString    ( ) const,
  asDebugInfo ( ) const;

#if 0 // -- Removing these for making it runtime neutral
friend ostream
 &operator << ( ostream&       aStream,
                const IBitmapHandle& aHandle );
#endif

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

protected:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IBitmapHandle


class IRegionHandle {
public:
/*---------------------------------- Value -----------------------------------*/
#ifdef IC_MOTIF
typedef void* Value;
#endif
#ifdef IC_PM
typedef unsigned long Value;
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
typedef HRGN__* Value;
 #else
typedef void* Value;
 #endif
#endif

/*------------------------------- Constructors -------------------------------*/
#ifdef IC_MOTIFPM
  IRegionHandle ( Value value=0 );
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
  IRegionHandle ( Value value = 0 );
  #else
  IRegionHandle ( void* value = 0 );
  #endif
 #else
  IRegionHandle ( Value value = 0 );
 #endif
#endif // IC_WIN

/*------------------------------- Diagnostics --------------------------------*/
IString
  asString    ( ) const,
  asDebugInfo ( ) const;

#if 0 // -- Removing these for making it runtime neutral
friend ostream
 &operator << ( ostream&       aStream,
                const IRegionHandle& aHandle );
#endif

unsigned long
  asUnsigned  ( ) const;

/*-------------------------------- Operators ---------------------------------*/
  operator Value ( ) const;

private:
/*---------------------------------- Value -----------------------------------*/
Value
  fhandle;
}; // IRegionHandle


#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <i2dghand.inl>

#endif // _I2DGHAND_
