// Revision: 65  1.7.1.3  source/albert/graph2d/i2dghand.cpp, 2d, ioc.v400, 001006  
/*******************************************************************************
* FILE NAME: i2dghand.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in i2dghand.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <i2dghand.hpp>
#include <istring.hpp>
#include <ibmpstat.hpp>
#ifdef IC_MOTIF
#include <ixdc.hpp>
#endif

// Segment definitions
#ifdef IC_PAGETUNE
#define _I2DGHAND_CPP_
#include <ipagetun.h>
#endif

#ifdef IC_PM

#ifndef IC_IPMDC
#include <ipmdc.hpp>
#endif // IC_IPMDC

/*------------------------------------------------------------------------------
| IPresSpaceHandle::IPresSpaceHandle                                           |
------------------------------------------------------------------------------*/
IPresSpaceHandle::IPresSpaceHandle ( Value value, INativeWindowHandle hwnd )
  : fhandle( (Value)(new IPMDC(value, hwnd)) )
  {
  }

unsigned long IPresSpaceHandle::asUnsigned ( ) const
{
  return (unsigned long) ((IPMDC*)this->fhandle)->fHPS;
}

IPresSpaceHandle::operator Value ( ) const
{
  return ((IPMDC*)this->fhandle)->fHPS;
}
#endif // IC_PM

/*------------------------------------------------------------------------------
| IPresSpaceHandle Destructor                                                  |
------------------------------------------------------------------------------*/
IPresSpaceHandle::~IPresSpaceHandle ()
{
#ifdef IC_MOTIF
   if (fhandle) {
      fhandle->decrementCount();
      if (fhandle->refCount() == 0)
         delete fhandle;
   }
#endif
#ifdef IC_PM
	if (fhandle) {
  		IPMDC* hdc = (IPMDC*)this->fhandle;
		hdc->decrementCount();
		if (hdc->refCount() == 0)
			delete hdc;
	}
#endif // IC_PM
}

/*------------------------------------------------------------------------------
| IPresSpaceHandle Copy Constructor                                            |
------------------------------------------------------------------------------*/
IPresSpaceHandle::IPresSpaceHandle (const IPresSpaceHandle& src)
  : fhandle(src.fhandle)
{
#ifdef IC_MOTIF
   if (fhandle)
      fhandle->incrementCount();
#endif
#ifdef IC_PM
	if (fhandle) {
  		IPMDC* hdc = (IPMDC*)this->fhandle;
		hdc->incrementCount();
	}
#endif // IC_PM
}

/*------------------------------------------------------------------------------
| IPresSpaceHandle Assignment Operator                                         |
------------------------------------------------------------------------------*/
IPresSpaceHandle& IPresSpaceHandle::operator= (const IPresSpaceHandle& src)
{
   if (this != &src) {
#ifdef IC_MOTIF
      if (fhandle) {              // out goes the old...
         fhandle->decrementCount();
         if (fhandle->refCount() == 0)
            delete fhandle;
      }

      fhandle = src.fhandle;      // in comes the new...

      if (fhandle)
         fhandle->incrementCount();
#endif
#ifdef IC_WIN
      fhandle = src.fhandle;
#endif
#ifdef IC_PM
	if (fhandle) {
  		IPMDC* hdc = (IPMDC*)this->fhandle;
		hdc->decrementCount();
		if (hdc->refCount() == 0)
			delete hdc;
	}

	fhandle = src.fhandle;      // in comes the new...

	if (fhandle) {
  		IPMDC* hdc = (IPMDC*)this->fhandle;
		hdc->incrementCount();
	}
#endif
   }

   return *this;
}

/*------------------------------------------------------------------------------
| IPresSpaceHandle::asString                                                   |
------------------------------------------------------------------------------*/
IString IPresSpaceHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IPresSpaceHandle::asDebugInfo                                                |
------------------------------------------------------------------------------*/
IString IPresSpaceHandle::asDebugInfo ( ) const
{
  IString result( "IPresSpaceHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}

#if 0 // -- Removing these for making it runtime neutral
/*------------------------------------------------------------------------------
| <<                                                                           |
------------------------------------------------------------------------------*/
ostream& operator << ( ostream &aStream, const IPresSpaceHandle& handle )
{
  return aStream << handle.asString();
}
#endif

#ifndef IC_WIN
/*------------------------------------------------------------------------------
| IBitmapHandle::IBitmapHandle                                                 |
------------------------------------------------------------------------------*/
IBitmapHandle::IBitmapHandle( Value value)
  : fhandle( value )
{
   if(value!=0)
     IBitmapStaticPtr::addBitmapRef( fhandle );
}
#endif // !IC_WIN

/*------------------------------------------------------------------------------
| IBitmapHandle::IBitmapHandle                                                 |
------------------------------------------------------------------------------*/
IBitmapHandle::IBitmapHandle(const IBitmapHandle& bitmapHandle)
  : fhandle( bitmapHandle )
{
   if(bitmapHandle!=0)
     IBitmapStaticPtr::addBitmapRef(bitmapHandle.fhandle);
}

/*------------------------------------------------------------------------------
| IBitmapHandle::~IBitmapHandle                                                |
------------------------------------------------------------------------------*/
IBitmapHandle::~IBitmapHandle()
{
   if(fhandle!=0)
     IBitmapStaticPtr::removeBitmapRef(fhandle);
}

/*------------------------------------------------------------------------------
| IBitmapHandle::operator =                                                    |
------------------------------------------------------------------------------*/
IBitmapHandle& IBitmapHandle::operator =(const IBitmapHandle& bitmapHandle)
{
   /* Note: Ensure self assignment works */
     if(this != &bitmapHandle)
     {
        if(bitmapHandle!=0)
            IBitmapStaticPtr::addBitmapRef(bitmapHandle.fhandle);
        if(*this!=0)
          IBitmapStaticPtr::removeBitmapRef(fhandle); // drop ref to current value
        this->fhandle = bitmapHandle;             // set self to new value
     }
     return *this;
}

/*------------------------------------------------------------------------------
| IBitmapHandle::asString                                                      |
------------------------------------------------------------------------------*/
IString IBitmapHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IBitmapHandle::asDebugInfo                                                   |
------------------------------------------------------------------------------*/
IString IBitmapHandle::asDebugInfo ( ) const
{
  IString result( "IBitmapHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}

#if 0 // -- Removing these for making it runtime neutral
/*------------------------------------------------------------------------------
| <<                                                                           |
------------------------------------------------------------------------------*/
ostream& operator << ( ostream &aStream, const IBitmapHandle& handle )
{
  return aStream << handle.asString();
}
#endif

/*------------------------------------------------------------------------------
 Note that pointer handles use references to reduce
  duplicate pointers for better storage utilization.
  See IReference, IRefCounted classes for more info.
------------------------------------------------------------------------------*/

#ifndef IC_WIN                                           // $HT!a
/*------------------------------------------------------------------------------
| IPointerHandle::IPointerHandle                                               |
------------------------------------------------------------------------------*/
IPointerHandle::IPointerHandle ( Value value )
  : fhandle( value )
{
   if ( value != 0 )
   {
      IBitmapStaticPtr::addPointerRef( fhandle );
   }
}
#endif // !IC_WIN                                           $HT!a

/*------------------------------------------------------------------------------
| IPointerHandle::IPointerHandle                                               |
------------------------------------------------------------------------------*/
IPointerHandle::IPointerHandle(const IPointerHandle& pointerHandle)
  : fhandle( pointerHandle )
{
   if(pointerHandle!=0)
     IBitmapStaticPtr::addPointerRef(pointerHandle.fhandle);
}

/*------------------------------------------------------------------------------
| IPointerHandle::~IPointerHandle                                              |
------------------------------------------------------------------------------*/
IPointerHandle::~IPointerHandle()
{
   if(fhandle!=0)
     IBitmapStaticPtr::removePointerRef(fhandle);
}

/*------------------------------------------------------------------------------
| IPointerHandle::asString                                                     |
------------------------------------------------------------------------------*/
IString IPointerHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IPointerHandle::asDebugInfo                                                  |
------------------------------------------------------------------------------*/
IString IPointerHandle::asDebugInfo ( ) const
{
  IString result( "IPointerHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}

#if 0 // -- Removing these for making it runtime neutral
/*------------------------------------------------------------------------------
| <<                                                                           |
------------------------------------------------------------------------------*/
ostream& operator << ( ostream &aStream, const IPointerHandle& handle )
{
  return aStream << handle.asString();
}
#endif


/*------------------------------------------------------------------------------
| IPointerHandle::operator =                                                   |
------------------------------------------------------------------------------*/
IPointerHandle& IPointerHandle::operator =(const IPointerHandle& pointerHandle)
{
   /* Note: Ensure self assignment works */
     if(this != &pointerHandle)
     {
       if(pointerHandle.fhandle!=0)
          IBitmapStaticPtr::addPointerRef(pointerHandle.fhandle);
       if(this->fhandle!=0)
          IBitmapStaticPtr::removePointerRef(fhandle);
       this->fhandle = pointerHandle.fhandle;
     }
     return *this;
}


/*------------------------------------------------------------------------------
| IRegionHandle::asString                                                      |
------------------------------------------------------------------------------*/
IString IRegionHandle::asString ( ) const
{
  return IString( this->asUnsigned() );
}

/*------------------------------------------------------------------------------
| IRegionHandle::asDebugInfo                                                   |
------------------------------------------------------------------------------*/
IString IRegionHandle::asDebugInfo ( ) const
{
  IString result( "IRegionHandle(" );
  result += ",handle=";
  result += this->asString();
  result += ")";
  return result;
}

#if 0 // -- Removing these for making it runtime neutral
/*------------------------------------------------------------------------------
| <<                                                                           |
------------------------------------------------------------------------------*/
ostream& operator << ( ostream &aStream, const IRegionHandle& handle )
{
  return aStream << handle.asString();
}
#endif
