/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 22 1.9.2.2 source/albert/graph2d/grinstan.cpp, 2d, ioc.v400, 001006 
/*================
||
||  File:   TemplateInstantiations.C
||
||  What:   Template instantiations for the geometry directory
||
||  Change History:
||
*/
#include <ibase.hpp>
#ifdef IC_MOTIF
extern "C"
{
#include <pthread.h>
}
#endif

#ifndef HIDE_TEMPLATE_DEFINITIONS
#define HIDE_TEMPLATE_DEFINITIONS
#endif

#define MAKE_TRawArray_DEFINITIONS_VISIBLE
#define MAKE_TStash_DEFINITIONS_VISIBLE
#define MAKE_TBaseCurve_DEFINITIONS_VISIBLE

#include <igrtypes.hpp>
#include <igbase2d.hpp>
#include <grassert.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
#define _GRINSTAN_CPP_
#include <ipagetun.h>
#endif

#pragma defineonly
#include <irawarr.hpp>
#include <ibcurve.hpp>
#include <ipt2darr.hpp>

#ifdef MAKE_TBaseCurve_DEFINITIONS_VISIBLE
#include "ibcurve.inl"
#include "redcurve.inl"
#include "arcleng.inl"
#endif

#include <regnextr.hpp>

#ifdef IC_MOTIF
// defect 29176
int __page_size;
int __page_size_K;
int __page_sizeX16;
int __page_sizeX24;
int __page_sizeM1;
pthread_mutex_t _mutex_global_np;
#endif


#pragma pack(push,4)

#pragma define( IRawArray<IStreamableRegionHandle> )

#pragma define( IRawArray<double> )
#pragma define( IRawArray<IGPoint2D> )
#pragma define( IRawArray<IGRPoint2D> )

#pragma define( IStash<double> )

#pragma define( IBaseCurve<IGRPoint2D, IGPoint2D> )

#pragma define( IGBounds<IGRPoint2D,IGPoint2D> )

#pragma define( ICurveIntegrator<IGRPoint2D, IGPoint2D> )

#pragma define( ICurveLengthRoot<IGRPoint2D, IGPoint2D> )

#pragma pack(pop)

#undef MAKE_TRawArray_DEFINITIONS_VISIBLE
#undef MAKE_TStash_DEFINITIONS_VISIBLE
#undef MAKE_TBaseCurve_DEFINITIONS_VISIBLE
