/*
*****************************************************************************************
*                                                                                       *
* COPYRIGHT:                                                                            *
*   IBM Open Class Library                                                              *
*   (C) Copyright International Business Machines Corporation,  1997                    *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.                  *
*   US Government Users Restricted Rights - Use, duplication, or disclosure             *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                              *
*                                                                                       *
*****************************************************************************************
*/
// Revision: 27 1.24.1.4 source/albert/graph2d/gdiimdev.cpp, 2d, ioc.v400, 001006 
/*

        name:   GdiImageDevice.C
        type:   C++

        This is the implementation of the IGdiImageDevice class.

        A IGdiImageDevice is a IOC GrafDevice based on a GDI
memory device context. The device context bitmap belongs to a
GHBITMAPImage geometry.

Change History:

*/

#include <ilanglvl.hpp>
#include <igimage.hpp>
#include <gdiimdev.hpp>    // IGdiImageDevice
#include <imagedc.hpp>
#include <igloop2d.hpp>
#include <igtxtrun.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
#define _GDIIMDEV_CPP_
#include <ipagetun.h>
#endif

#ifdef IC_PM
#include <winemul.h>
#endif

/*================================================================
||
||      IGdiImageDevice  implementation
||
*/

#if !IC_RTTI_ENABLED
GrafDeviceTypeDefinitionsMacro(IGdiImageDevice);
#endif // IC_RTTI_ENABLED

/*================================================================
||
||      Constructors
||
*/



#if defined(IC_WIN)
IGdiImageDevice::IGdiImageDevice(IGImage* aliasImage, IPresSpaceHandle hdcMem) :
   IGdiDevice(hdcMem, IGImage::imageBounds(*aliasImage)),
       fImage(aliasImage)
{}
#elif defined(IC_PM)
IGdiImageDevice::IGdiImageDevice(IGImage* aliasImage, IPresSpaceHandle hdcMem) :
   IGpiDevice(hdcMem, IGImage::imageBounds(*aliasImage)),
    fImage(aliasImage)
{}
#endif

// these three functions are disabled...
IGdiImageDevice::IGdiImageDevice()
{
// shouldn't be called
}

IGdiImageDevice::IGdiImageDevice(const IGdiImageDevice&)
{
// shouldn't be called
}

IGdiImageDevice& IGdiImageDevice::operator=(const IGdiImageDevice& Src )
{
// shouldn't be called
   return *this;
}


/*================================================================
||
||  IGdiImageDevice::~IGdiImageDevice
||
*/

IGdiImageDevice::~IGdiImageDevice ()
{}


class BitmapContext {
public:
	BitmapContext(const IPresSpaceHandle& ps, HBITMAP theNewBitmap);
	~BitmapContext();
private:
	HBITMAP fOrigBitmap;
	IPresSpaceHandle fDevContext;
};


BitmapContext::BitmapContext(const IPresSpaceHandle& ps, HBITMAP theNewBitmap) :
	fDevContext(ps)
{
  	fOrigBitmap = (HBITMAP) SelectObject( ps, theNewBitmap );
}

BitmapContext::~BitmapContext() {	
	SelectObject(fDevContext, fOrigBitmap);
}


void IGdiImageDevice::renderLine(const IGLine2D& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderLine(geometry, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderLine(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderPolyline(const IGPolyline2D& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderPolyline(geometry, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderPolyline(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderRect(const IGRect2D& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderRect(geometry, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderRect(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderEllipse(const IGEllipse2D& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderEllipse(geometry, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderEllipse(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderPolygon(const IGPolygon2D& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderPolygon(geometry, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderPolygon(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderArea(const IGArea& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderArea(geometry, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderArea(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderCurve(const IGCurve2D& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderCurve(geometry, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderCurve(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderLoop(const IGLoop2D& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderLoop(geometry, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderLoop(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderImage(
	const IGImage& image,
	const IGRect2D& source,
	const IGrafState& grafState)
{
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderImage(image, source, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderImage(image, source, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

void IGdiImageDevice::renderMaskedImage(
	const IGImage& image,
	const IGImage& mask,
	const IGRect2D& source,
	const IGrafState& grafState)
{
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGdiDevice::renderMaskedImage(image, mask, source, grafState);
#elif defined(IC_PM)
   IGpiDevice::renderMaskedImage(image, mask, source, grafState);
#endif

	fImage->setImageSyncFlag(true);
}

IGPoint2D IGdiImageDevice::renderTextRun(const IGTextRun& geometry, const IGrafState& grafState) {
	IPresSpaceHandle tmp = deviceContext();
	BitmapContext bmc(tmp, fImage->handle());
#if defined(IC_WIN)
   IGPoint2D pnt = IGdiDevice::renderTextRun(geometry, grafState);
#elif defined(IC_PM)
   IGPoint2D pnt = IGpiDevice::renderTextRun(geometry, grafState);
#endif

	fImage->setImageSyncFlag(true);
	return pnt;
}
