#ifndef __stdio_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __stdio_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined _OPTLINK_SUPPORTED
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <stdio.h> Header File                                           */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #ifndef __size_t
      #define __size_t
      typedef unsigned int size_t;
   #endif

   enum _OPERATIONS { _IOINIT, _IOREAD, _IOWRITE, _IOREPOSITION,
                      _IOFLUSH, _IOUNDEFOP };

   #define _MAX_UNGET 2

   #pragma pack(1)
   typedef struct __file {  /* visible portion of the FILE struct */
      unsigned char     *_bufPtr;
      unsigned long int  _filler1; /* 3.0, 3.5: _count */
      unsigned long int  _userFlags;
      unsigned long int  _bufLen;
      unsigned long int  _ungetCount;
      unsigned long int  _filler2; /* 3.0, 3.5: _tempStore; 3.6.0: _bufCount */
      unsigned char      _ungetBuf[_MAX_UNGET];
      char               _filler3; /* 3.0, 3.5: _lastOp */
      enum _OPERATIONS   _lastOp;
      signed char        _orientation;
      unsigned char     *_buf;
      unsigned long int  _bufCount;
      unsigned long int  _count;
      } FILE;
   #pragma pack()

   typedef struct __fpos_t {  /* Definition of file positioning structure */
      long int __fpos_elem[2];
      } fpos_t;

   #ifndef NULL
      #if __EXTENDED__ || __cplusplus
         #define NULL 0
      #else
         #define NULL ((void *)0)
      #endif
   #endif

   #define _IOFBF              1   /* Buffer modes */
   #define _IOLBF              2
   #define _IONBF              3
   #define BUFSIZ           4096   /* Default buffer size */
   #define EOF              (-1)
   #define L_tmpnam          260   /* Maximum length of temporary names */
   #define FOPEN_MAX          20   /* Minimum number of open files guaranteed */
   #define FILENAME_MAX      260   /* Maximum file name length */
   #define SEEK_SET            0   /* fseek constants */
   #define SEEK_CUR            1
   #define SEEK_END            2
   #define TMP_MAX        100000   /* Maximum guaranteed unique file names */

   #define _IOEOF         0x0001   /* EOF flag mask */
   #define _IOERR         0x0002   /* ERR flag mask */

   #ifndef __def_va_list
      #define __def_va_list
      #if __THW_PPC__ && __OS2__
         typedef struct {
            char gpr;
            char fpr;
            char reserved[2];
            char *input_arg_area;
            char *reg_save_area;
         } __va_list[1];
      #else
         typedef char *__va_list;
      #endif
   #endif

   /* Standard stream pointers. */

   extern FILE *const _IMPORT stdin;
   extern FILE *const _IMPORT stdout;
   extern FILE *const _IMPORT stderr;
   #define stdin stdin
   #define stdout stdout
   #define stderr stderr

   /* Function declarations. */

   extern int      _IMPORT _LNK_CONV fprintf(FILE *, const char *, ...);
   extern int      _IMPORT _LNK_CONV fscanf(FILE *, const char *, ...);
   extern int      _IMPORT _LNK_CONV printf(const char *, ...);
   extern int      _IMPORT _LNK_CONV scanf(const char *, ...);
   extern int      _IMPORT _LNK_CONV sprintf(char *, const char *, ...);
   extern int      _IMPORT _LNK_CONV sscanf(const char *, const char *, ...);
   extern void     _IMPORT _LNK_CONV clearerr(FILE *);
   extern int      _IMPORT _LNK_CONV fclose(FILE *);
   extern int      _IMPORT _LNK_CONV feof(FILE *);
   extern int      _IMPORT _LNK_CONV ferror(FILE *);
   extern int      _IMPORT _LNK_CONV fflush(FILE *);
   extern int      _IMPORT _LNK_CONV fgetc(FILE *);
   extern int      _IMPORT _LNK_CONV fgetpos(FILE *, fpos_t *);
   extern char    *_IMPORT _LNK_CONV fgets(char *, int, FILE *);
   extern FILE    *_IMPORT _LNK_CONV fopen(const char *, const char *);
   extern int      _IMPORT _LNK_CONV fputc(int, FILE *);
   extern int      _IMPORT _LNK_CONV fputs(const char *, FILE *);
   extern size_t   _IMPORT _LNK_CONV fread(void *, size_t, size_t, FILE *);
   extern FILE    *_IMPORT _LNK_CONV freopen(const char *, const char *, FILE *);
   extern int      _IMPORT _LNK_CONV fseek(FILE *, long int, int);
   extern int      _IMPORT _LNK_CONV fsetpos(FILE *, const fpos_t *);
   extern long int _IMPORT _LNK_CONV ftell(FILE *);
   extern size_t   _IMPORT _LNK_CONV fwrite(const void *, size_t, size_t, FILE *);
   extern int              _LNK_CONV getc(FILE *);
   extern int              _LNK_CONV getchar(void);
   extern char    *_IMPORT _LNK_CONV gets(char *);
   extern void     _IMPORT _LNK_CONV perror(const char *);
   extern int              _LNK_CONV putc(int, FILE *);
   extern int              _LNK_CONV putchar(int);
   extern int      _IMPORT _LNK_CONV puts(const char *);
   extern int      _IMPORT _LNK_CONV remove(const char *);
   extern int      _IMPORT _LNK_CONV rename(const char *, const char *);
   extern void     _IMPORT _LNK_CONV rewind(FILE *);
   extern void     _IMPORT _LNK_CONV setbuf(FILE *, char *);
   extern int      _IMPORT _LNK_CONV setvbuf(FILE *, char *, int, size_t);
   extern FILE    *_IMPORT _LNK_CONV tmpfile(void);
   extern char    *_IMPORT _LNK_CONV tmpnam(char *);
   extern int      _IMPORT _LNK_CONV ungetc(int, FILE *);
   extern int      _IMPORT _LNK_CONV vfprintf(FILE *, const char *, __va_list);
   extern int      _IMPORT _LNK_CONV vprintf(const char *, __va_list);
   extern int      _IMPORT _LNK_CONV vsprintf(char *, const char *, __va_list);

   #define __getc(p) (                               \
         ( 0 < (p)->_bufCount ) ?                    \
         (--(p)->_bufCount, (int)(*(p)->_bufPtr++)): \
         fgetc((p))                                  \
      )

   #define __putc(c, p) (                           \
         ( 0 < (p)->_bufCount ) ?                   \
         (--(p)->_bufCount, *(p)->_bufPtr++ = (c)): \
         fputc((c),(p))                             \
      )

   #ifndef __MULTI__
      #ifdef __cplusplus
         inline int getc(FILE * __p) { return __getc(__p); }
         inline int putc(int __c, FILE * __p) { return __putc(__c, __p); }
      #else
         #define getc(p) __getc(p)
         #define putc(c, p) __putc(c, p)
      #endif
   #else
      #ifdef __cplusplus
         inline int getc(FILE *__p) { return fgetc(__p); }
         inline int putc(int __c, FILE *__p) { return fputc(__c, __p); }
      #else
         #define getc(p) fgetc(p)
         #define putc(c, p) fputc(c, p)
      #endif
   #endif

   #ifdef __cplusplus
      inline int getchar(void)   { return getc(stdin); }
      inline int putchar(int __c) { return putc(__c, stdout); }
   #else
      #define getchar()   getc(stdin)
      #define putchar(c) putc(c, stdout)
   #endif

   /* clearerr, feof, and ferror macros - single threaded only */

   #if !__MULTI__
      #if __cplusplus
         inline void clearerr(FILE *__f) { __f->_userFlags = 0; }
         inline int feof(FILE *__f) { return __f->_userFlags & _IOEOF; }
         inline int ferror(FILE *__f) {return __f->_userFlags & _IOERR; }
      #else
         #define clearerr(stream) ((void)((stream)->_userFlags = 0L))
         #define feof(stream)     ((int)((stream)->_userFlags & _IOEOF))
         #define ferror(stream)   ((int)((stream)->_userFlags & _IOERR))
      #endif
   #endif

   #if (__IBMC__ || IBMCPP__) && __LIBANSI__
      #pragma isolated_call(clearerr)
      #pragma isolated_call(feof)
      #pragma isolated_call(ferror)
      #pragma isolated_call(sprintf)
      #pragma isolated_call(vsprintf)
      #if __IGNERRNO__
         #pragma isolated_call(fgetpos)
         #pragma isolated_call(ftell)
         #pragma isolated_call(setbuf)
         #pragma isolated_call(setvbuf)
      #endif
   #endif

   #if __EXTENDED__ || __cplusplus

      #define _IO_WRITETHRU  0x0004   /* WRITETHRU mask */

      #if __IBMC__ || __IBMCPP__
         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(fprintf, "?_fprintfieee")
            #pragma map(printf, "?_printfieee")
            #pragma map(sprintf, "?_sprintfieee")
            #pragma map(fscanf, "?_fscanfieee")
            #pragma map(scanf, "?_scanfieee")
            #pragma map(sscanf, "?_sscanfieee")
            #pragma map(vfprintf, "?_vfprintfieee")
            #pragma map(vprintf , "?_vprintfieee")
            #pragma map(vsprintf, "?_vsprintfieee")
         #else
            #pragma map(fprintf, "_fprintfieee")
            #pragma map(printf, "_printfieee")
            #pragma map(sprintf, "_sprintfieee")
            #pragma map(fscanf, "_fscanfieee")
            #pragma map(scanf, "_scanfieee")
            #pragma map(sscanf, "_sscanfieee")
            #pragma map(vfprintf, "_vfprintfieee")
            #pragma map(vprintf, "_vprintfieee")
            #pragma map(vsprintf, "_vsprintfieee")
         #endif
      #else
         extern int _IMPORT _LNK_CONV _fprintfieee(FILE *, const char *, ...);
         extern int _IMPORT _LNK_CONV _fscanfieee(FILE *, const char *, ...);
         extern int _IMPORT _LNK_CONV _printfieee(const char *, ...);
         extern int _IMPORT _LNK_CONV _scanfieee(const char *, ...);
         extern int _IMPORT _LNK_CONV _sprintfieee(char *, const char *, ...);
         extern int _IMPORT _LNK_CONV _sscanfieee(const char *, const char *, ...);
         extern int _IMPORT _LNK_CONV _vfprintfieee(FILE *, const char *, __va_list);
         extern int _IMPORT _LNK_CONV _vprintfieee(const char *, __va_list);
         extern int _IMPORT _LNK_CONV _vsprintfieee(char *, const char *, __va_list);

         #define fprintf _fprintfieee
         #define printf _printfieee
         #define sprintf _sprintfieee
         #define fscanf _fscanfieee
         #define scanf _scanfieee
         #define sscanf _sscanfieee
         #define vfprintf _vfprintfieee
         #define vprintf _vprintfieee
         #define vsprintf _vsprintfieee
      #endif

      int _LNK_CONV _fcloseall(void);
      int _LNK_CONV _rmtmp(void);

      #define P_tmpdir "\\"

      extern FILE *_IMPORT _LNK_CONV fdopen(int, const char *);
      extern int   _IMPORT _LNK_CONV fgetchar(void);
      extern int   _IMPORT _LNK_CONV fileno(FILE *);
      extern int   _IMPORT _LNK_CONV flushall(void);
      extern int   _IMPORT _LNK_CONV fputchar(int);
      extern char *_IMPORT _LNK_CONV tempnam(char *, char *);
      extern int   _IMPORT _LNK_CONV unlink(const char *);

      extern FILE *_IMPORT _LNK_CONV _fdopen(int, const char *);
      extern int   _IMPORT _LNK_CONV _fgetchar(void);
      extern int   _IMPORT _LNK_CONV _fileno(FILE *);
      extern int   _IMPORT _LNK_CONV _flushall(void);
      extern int   _IMPORT _LNK_CONV _fputchar(int);
      extern char *_IMPORT _LNK_CONV _tempnam(char *, char *);
      extern int   _IMPORT _LNK_CONV _unlink(const char *);

      extern int   _IMPORT _LNK_CONV _set_crt_msg_handle(int);

      #if (__IBMC__ || IBMCPP__) && __LIBANSI__ && __IGNERRNO__
         #pragma isolated_call(fdopen)
         #pragma isolated_call(fileno)
      #endif

      #if __IBMC__ || __IBMCPP__
         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(fdopen, "?_fdopen")
            #pragma map(fgetchar, "?_fgetchar")
            #pragma map(fileno, "?_fileno")
            #pragma map(flushall, "?_flushall")
            #pragma map(fputchar, "?_fputchar")
            #pragma map(tempnam, "?_tempnam")
            #ifndef __unlink
               #define __unlink
               #pragma map(unlink, "?_unlink")
            #endif
         #else
            #pragma map(fdopen, "_fdopen")
            #pragma map(fgetchar, "_fgetchar")
            #pragma map(fileno, "_fileno")
            #pragma map(flushall, "_flushall")
            #pragma map(fputchar, "_fputchar")
            #pragma map(tempnam, "_tempnam")
            #ifndef __unlink
               #define __unlink
               #pragma map(unlink, "_unlink")
            #endif
         #endif
      #endif
   #elif __IBMC__ || __IBMCPP__
      #if __WINDOWS__ && __THW_INTEL__
         #pragma map(fprintf, "?_fprintfansi")
         #pragma map(printf, "?_printfansi")
         #pragma map(sprintf, "?_sprintfansi")
         #pragma map(fscanf, "?_fscanfansi")
         #pragma map(scanf, "?_scanfansi")
         #pragma map(sscanf, "?_sscanfansi")
      #else
         #pragma map(fprintf, "_fprintfansi")
         #pragma map(printf, "_printfansi")
         #pragma map(sprintf, "_sprintfansi")
         #pragma map(fscanf, "_fscanfansi")
         #pragma map(scanf, "_scanfansi")
         #pragma map(sscanf, "_sscanfansi")
      #endif
   #endif

   #if __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

