#ifndef __stddef_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __stddef_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <stddef.h> Header File                                          */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   typedef int ptrdiff_t;

   #ifndef __size_t
      #define __size_t
      typedef unsigned int size_t;
   #endif

   #if !__cplusplus && !defined __wchar_t
      #define __wchar_t
      typedef unsigned short wchar_t;
   #endif

   #ifndef NULL
      #if __EXTENDED__ || __cplusplus
         #define NULL 0
      #else
         #define NULL ((void *)0)
      #endif
   #endif

   #if __IBMC__ || __IBMCPP__
      #define offsetof(x, y) __offsetof(x, y)
   #else
      #define offsetof(x, y) (size_t)&(((x*)0)->y)
   #endif

   #if __EXTENDED__
      #if __THW_PPC__
         extern size_t _IMPORT _LNK_CONV _threadalloc(size_t len);
         extern void * _IMPORT _LNK_CONV _threadlocal(size_t var);
      #endif

      #ifndef errno
         #if __MULTI__
            extern int *_IMPORT _LNK_CONV _errno(void);
            #define errno (*_errno())
            #if (__IBMC__ || __IBMCPP__) && __LIBANSI__
               #pragma isolated_call(_errno)
            #endif
         #else
            extern int _IMPORT errno;
            #define errno errno
         #endif
      #endif

      #if __MULTI__
         extern unsigned *_IMPORT _LNK_CONV __threadid(void);
         #define _threadid __threadid()
      #endif
   #endif

   #ifdef __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

