#ifndef __process_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __process_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV   _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <process.h> Header File                                         */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #if __EXTENDED__

      /* Modeflag values for spawnxx routines */

      #define P_WAIT          0
      #define P_NOWAIT        1
      #define P_OVERLAY       2

      /* Action codes used with cwait() */

      #define WAIT_CHILD      0
      #define WAIT_GRANDCHILD 1

      /* function prototypes */

      extern void _IMPORT _LNK_CONV abort(void);
      extern void         _LNK_CONV exit(int);
      extern int  _IMPORT _LNK_CONV system(const char *);

      extern void _IMPORT _LNK_CONV _exit(int);

      extern int  _IMPORT _LNK_CONV _execl(const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV _execle(const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV _execlp(const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV _execlpe(const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV _spawnl(int, const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV _spawnle(int, const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV _spawnlp(int, const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV _spawnlpe(int, const char *, const char *, ...);

      extern int  _IMPORT _LNK_CONV execl(const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV execle(const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV execlp(const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV execlpe(const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV spawnl(int, const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV spawnle(int, const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV spawnlp(int, const char *, const char *, ...);
      extern int  _IMPORT _LNK_CONV spawnlpe(int, const char *, const char *, ...);

      extern int  _IMPORT _LNK_CONV _cwait(int *, int, int);
      extern int  _IMPORT _LNK_CONV _execv(const char *, const char * const *);
      extern int  _IMPORT _LNK_CONV _execve(const char *, const char * const *, const char * const *);
      extern int  _IMPORT _LNK_CONV _execvp(const char *, const char * const *);
      extern int  _IMPORT _LNK_CONV _execvpe(const char *, const char * const *, const char * const *);
      extern int  _IMPORT _LNK_CONV _getpid(void);
      extern int  _IMPORT _LNK_CONV _spawnv(int, const char *, const char * const *);
      extern int  _IMPORT _LNK_CONV _spawnve(int, const char *, const char * const *, const char * const *);
      extern int  _IMPORT _LNK_CONV _spawnvp(int, const char *, const char * const *);
      extern int  _IMPORT _LNK_CONV _spawnvpe(int, const char *, const char * const *, const char * const *);
      #if __OS2__
         extern int  _IMPORT _LNK_CONV _wait(int *);
      #endif

      extern int  _IMPORT _LNK_CONV cwait(int *, int, int);
      extern int  _IMPORT _LNK_CONV execv(const char *, const char * const *);
      extern int  _IMPORT _LNK_CONV execve(const char *, const char * const *, const char * const *);
      extern int  _IMPORT _LNK_CONV execvp(const char *, const char * const *);
      extern int  _IMPORT _LNK_CONV execvpe(const char *, const char * const *, const char * const *);
      extern int  _IMPORT _LNK_CONV getpid(void);
      extern int  _IMPORT _LNK_CONV spawnv(int, const char *, const char * const *);
      extern int  _IMPORT _LNK_CONV spawnve(int, const char *, const char * const *, const char * const *);
      extern int  _IMPORT _LNK_CONV spawnvp(int, const char *, const char * const *);
      extern int  _IMPORT _LNK_CONV spawnvpe(int, const char *, const char * const *, const char * const *);
      #if __OS2__
         extern int  _IMPORT _LNK_CONV wait(int *);
      #endif

      #if __IBMC__ || __IBMCPP__
         #if __LIBANSI__
            #pragma leaves(abort)
            #pragma leaves(exit)
            #pragma leaves(_exit)
            #pragma isolated_call(getpid)
         #endif

         #if __WINDOWS__ && __THW_INTEL__
            #pragma map(_execl, "?_execl_ansi")
            #pragma map(_execle, "?_execle_ansi")
            #pragma map(_execlp, "?_execlp_ansi")
            #pragma map(_execlpe, "?_execlpe_ansi")
            #pragma map(_spawnl, "?_spawnl_ansi")
            #pragma map(_spawnle, "?_spawnle_ansi")
            #pragma map(_spawnlp, "?_spawnlp_ansi")
            #pragma map(_spawnlpe, "?_spawnlpe_ansi")
            #pragma map(execl, "?_execl_ansi")
            #pragma map(execle, "?_execle_ansi")
            #pragma map(execlp, "?_execlp_ansi")
            #pragma map(execlpe, "?_execlpe_ansi")
            #pragma map(spawnl, "?_spawnl_ansi")
            #pragma map(spawnle, "?_spawnle_ansi")
            #pragma map(spawnlp, "?_spawnlp_ansi")
            #pragma map(spawnlpe, "?_spawnlpe_ansi")
            #pragma map(cwait, "?_cwait")
            #pragma map(execv, "?_execv")
            #pragma map(execve, "?_execve")
            #pragma map(execvp, "?_execvp")
            #pragma map(execvpe, "?_execvpe")
            #pragma map(getpid, "?_getpid")
            #pragma map(spawnv, "?_spawnv")
            #pragma map(spawnve, "?_spawnve")
            #pragma map(spawnvp, "?_spawnvp")
            #pragma map(spawnvpe, "?_spawnvpe")
         #else
            #pragma map(_execl, "_execl_ansi")
            #pragma map(_execle, "_execle_ansi")
            #pragma map(_execlp, "_execlp_ansi")
            #pragma map(_execlpe, "_execlpe_ansi")
            #pragma map(_spawnl, "_spawnl_ansi")
            #pragma map(_spawnle, "_spawnle_ansi")
            #pragma map(_spawnlp, "_spawnlp_ansi")
            #pragma map(_spawnlpe, "_spawnlpe_ansi")
            #pragma map(execl, "_execl_ansi")
            #pragma map(execle, "_execle_ansi")
            #pragma map(execlp, "_execlp_ansi")
            #pragma map(execlpe, "_execlpe_ansi")
            #pragma map(spawnl, "_spawnl_ansi")
            #pragma map(spawnle, "_spawnle_ansi")
            #pragma map(spawnlp, "_spawnlp_ansi")
            #pragma map(spawnlpe, "_spawnlpe_ansi")
            #pragma map(cwait, "_cwait")
            #pragma map(execv, "_execv")
            #pragma map(execve, "_execve")
            #pragma map(execvp, "_execvp")
            #pragma map(execvpe, "_execvpe")
            #pragma map(getpid, "_getpid")
            #pragma map(spawnv, "_spawnv")
            #pragma map(spawnve, "_spawnve")
            #pragma map(spawnvp, "_spawnvp")
            #pragma map(spawnvpe, "_spawnvpe")
            #pragma map(wait, "_wait")
         #endif
      #else
         #define execl _execl_ansi
         #define execle _execle_ansi
         #define execlp _execlp_ansi
         #define execlpe _execlpe_ansi
         #define spawnl _spawnl_ansi
         #define spawnle _spawnle_ansi
         #define spawnlp _spawnlp_ansi
         #define spawnlpe _spawnlpe_ansi
         #define cwait _cwait
         #define execv _execv
         #define execve _execve
         #define execvp _execvp
         #define execvpe _execvpe
         #define getpid _getpid
         #define spawnv _spawnv
         #define spawnve _spawnve
         #define spawnvp _spawnvp
         #define spawnvpe _spawnvpe
         #define wait _wait
      #endif

      #if __MULTI__
         extern int  _IMPORT _LNK_CONV _beginthread(void (* _LNK_CONV)(void *), void *, unsigned, void *);
         extern void _IMPORT _LNK_CONV _endthread(void);
         extern void ** _IMPORT _LNK_CONV _threadstore(void);
      #endif

   #endif

   #if __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

