#if !defined __memory_h && !defined __string_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __memory_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined _OPTLINK_SUPPORTED
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <memory.h> Header File                                          */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #if !defined __COMPATSTR__
      #if __IBMCPP__ < 400
         #define __COMPATSTR__ 1
      #else
         #define __COMPATSTR__ 0
      #endif
   #endif

   #ifndef __size_t
      #define __size_t
      typedef unsigned int size_t;
   #endif

   #if (__THW_INTEL__ || __THW_PPC__ && __STR__) && (__IBMC__ || __IBMCPP__)
      #if __cplusplus
         extern "builtin" void  *__memchr(const void *, int, size_t);
         extern "builtin" void  *__memcpy(void *, const void *, size_t);
         extern "builtin" int __memcmp(const void *, const void *, size_t);
         extern "builtin" void  *__memmove(void *, const void *, size_t);
         extern "builtin" void  *__memset(void *, int, size_t);
         #if __COMPATSTR__
            inline void *_LNK_CONV memchr(const void *__m, int __ch, size_t __len)
                                 { return __memchr(__m, __ch, __len); }
         #else
            inline const void *_LNK_CONV memchr(const void *__m, int __ch, size_t __len)
                                 { return __memchr(__m, __ch, __len); }
         #endif
         inline int   _LNK_CONV memcmp(const void *__m1, const void *__m2, size_t __len)
                                { return __memcmp(__m1, __m2, __len); }
         inline void *_LNK_CONV memcpy(void *__m1, const void *__m2, size_t __len)
                                { return __memcpy(__m1, __m2, __len); }
         inline void *_LNK_CONV memmove(void *__m1, const void *__m2, size_t __len)
                                { return __memmove(__m1, __m2, __len); }
         inline void *_LNK_CONV memset(void *__m, int __ch, size_t __len)
                                { return __memset(__m, __ch, __len); }
      #else
         void *_Builtin __memchr(const void *, int, size_t);
         void *_Builtin __memcpy(void *, const void *, size_t);
         int   _Builtin __memcmp(const void *, const void *, size_t);
         void *_Builtin __memmove(void *, const void *, size_t);
         void *_Builtin __memset(void *, int, size_t);
         extern void *_IMPORT _LNK_CONV memchr(const void *, int, size_t);
         extern int   _IMPORT _LNK_CONV memcmp(const void *, const void *, size_t);
         extern void *_IMPORT _LNK_CONV memcpy(void *, const void *, size_t);
         extern void *_IMPORT _LNK_CONV memmove(void *, const void *, size_t);
         extern void *_IMPORT _LNK_CONV memset(void *, int, size_t);

         #define memchr(x, y, z)  __memchr(x, y, z)
         #define memcmp(x, y, z)  __memcmp(x, y, z)
         #define memcpy(x, y, z)  __memcpy(x, y, z)
         #define memmove(x, y, z)  __memmove(x, y, z)
         #define memset(x, y, z)  __memset(x, y, z)
      #endif
      #pragma isolated_call(__memchr)
      #pragma isolated_call(__memcpy)
      #pragma isolated_call(__memcmp)
      #pragma isolated_call(__memmove)
      #pragma isolated_call(__memset)
   #else
      extern void *_IMPORT _LNK_CONV memcpy(void *, const void *, size_t);
      extern void *_IMPORT _LNK_CONV memmove(void *, const void *, size_t);
      #if __cplusplus && !__COMPATSTR__
         extern const void *_IMPORT _LNK_CONV memchr(const void *, int, size_t);
      #else
         extern void *_IMPORT _LNK_CONV memchr(const void *, int, size_t);
      #endif
      extern int   _IMPORT _LNK_CONV memcmp(const void *, const void *, size_t);
      extern void *_IMPORT _LNK_CONV memset(void *, int, size_t);
   #endif

   extern void *_IMPORT _LNK_CONV memccpy(void *, const void *, int, unsigned int);
   extern int   _IMPORT _LNK_CONV memicmp(const void *, const void *, unsigned int);

   extern void *_IMPORT _LNK_CONV _fmemcpy(void *, const void *, size_t);
   extern void *_IMPORT _LNK_CONV _fmemchr(const void *, int, size_t);
   extern int   _IMPORT _LNK_CONV _fmemcmp(const void *, const void *, size_t);
   extern void *_IMPORT _LNK_CONV _fmemset(void *, int, size_t);
   extern void *_IMPORT _LNK_CONV _fmemccpy(void *, const void *, int, unsigned int);
   extern int   _IMPORT _LNK_CONV _fmemicmp(const void *, const void *, unsigned int);

   #ifdef __DEBUG_ALLOC__
      extern void *_IMPORT _LNK_CONV _debug_memcpy(void *, const void *, size_t, const char *, size_t);
      extern void *_IMPORT _LNK_CONV _debug_memset(void *, int, size_t, const char *, size_t);
      extern void *_IMPORT _LNK_CONV _debug_memmove(void *, const void *, size_t, const char *, size_t);
      #undef memcpy
      #undef memset
      #undef memmove
      #define memcpy(x, y, z) _debug_memcpy(x, y, z, __FILE__, __LINE__)
      #define memset(x, y, z) _debug_memset(x, y, z, __FILE__, __LINE__)
      #define memmove(x, y, z) _debug_memmove(x, y, z, __FILE__, __LINE__)
   #endif

   #if __IBMC__ || __IBMCPP__
      #if __WINDOWS__ && __THW_INTEL__
         #pragma map(_fmemcpy, "?memcpy")
         #pragma map(_fmemchr, "?memchr")
         #pragma map(_fmemcmp, "?memcmp")
         #pragma map(_fmemset, "?memset")
         #pragma map(_fmemccpy, "?memccpy")
         #pragma map(_fmemicmp, "?memicmp")
      #else
         #pragma map(_fmemcpy, "memcpy")
         #pragma map(_fmemchr, "memchr")
         #pragma map(_fmemcmp, "memcmp")
         #pragma map(_fmemset, "memset")
         #pragma map(_fmemccpy, "memccpy")
         #pragma map(_fmemicmp, "memicmp")
      #endif
   #else
      #define _fmemcpy memcpy
      #define _fmemchr memchr
      #define _fmemcmp memcmp
      #define _fmemset memset
      #define _fmemccpy memccpy
      #define _fmemicmp memicmp
   #endif

   #if __cplusplus
      }
      #if !__COMPATSTR__
         inline void *memchr(void *__s, int __ch, size_t __n)
                                    { return (void*)memchr((const void *)__s, __ch, __n); }
      #endif
   #endif

   #if (__IBMC__ || IBMCPP__) && __LIBANSI__
      #pragma isolated_call(memcpy)
      #pragma isolated_call(memmove)
      #pragma isolated_call(memcmp)
      #pragma isolated_call(memchr)
      #pragma isolated_call(memset)
      #pragma isolated_call(memccpy)
      #pragma isolated_call(memicmp)
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

