#ifndef __locale_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __locale_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #if __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <locale.h> Header File                                          */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #ifndef NULL
      #if __EXTENDED__ || __cplusplus
         #define NULL 0
      #else
         #define NULL ((void *)0)
      #endif
   #endif

   /* Categories */

   #define LC_ALL       (-1)
   #define LC_COLLATE    0
   #define LC_CTYPE      1
   #define LC_NUMERIC    2
   #define LC_MONETARY   3
   #define LC_TIME       4
   #define LC_TOD        5
   #define LC_MESSAGES   6
   #define LC_SYNTAX     7

   /* Locales */

   #define LC_C "C"

   struct lconv {
      char *decimal_point;
      char *thousands_sep;
      char *grouping;
      char *int_curr_symbol;
      char *currency_symbol;
      char *mon_decimal_point;
      char *mon_thousands_sep;
      char *mon_grouping;
      char *positive_sign;
      char *negative_sign;
      char  int_frac_digits;
      char  frac_digits;
      char  p_cs_precedes;
      char  p_sep_by_space;
      char  n_cs_precedes;
      char  n_sep_by_space;
      char  p_sign_posn;
      char  n_sign_posn;
      char *left_parenthesis;
      char *right_parenthesis;
      char *debit_sign;
      char *credit_sign;
      };

   /* Prototype definitions */

   extern char         *_IMPORT _LNK_CONV setlocale(int, const char *);
   extern struct lconv *_IMPORT _LNK_CONV localeconv(void);
   #if (__IBMC__ || IBMCPP__) && __LIBANSI__
      #pragma isolated_call(localeconv)
   #endif

   #if __EXTENDED__
      struct dtconv {
         char *abbrev_month_names[12]; /* Abbreviated month names      */
         char *month_names[12];        /* full month names             */
         char *abbrev_day_names[7];    /* Abbreviated day names        */
         char *day_names[7];           /* full day names               */
         char *date_time_format;       /* date and time format         */
         char *date_format;            /* date format                  */
         char *time_format;            /* time format                  */
         char *am_string;              /* AM string                    */
         char *pm_string;              /* PM string                    */
         char *time_format_ampm;       /* long date format             */
      };

      extern struct dtconv *_IMPORT _LNK_CONV localdtconv(void);
      #if (__IBMC__ || IBMCPP__) && __LIBANSI__
         #pragma isolated_call(localdtconv)
      #endif
   #endif

   #if __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

