#ifndef __langinfo_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __langinfo_h

   #if __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <langinfo.h> Header File                                        */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #include <nl_types.h>

   #define CODESET    1  /* codeset name */
   #define D_T_FMT    2  /* string for formatting date and time */
   #define D_FMT      3  /* string for formatting date */
   #define T_FMT      4  /* string for formatting time */
   #define T_FMT_AMPM 5  /* string for am or pm file format */
   #define AM_STR     6  /* string for a.m. */
   #define PM_STR     7  /* string for p.m. */

   #define ABDAY_1    8  /* abbreviated first day of the week (Sun) */
   #define ABDAY_2    9  /* abbreviated second day of the week (Mon) */
   #define ABDAY_3   10  /* abbreviated third day of the week (Tue) */
   #define ABDAY_4   11  /* abbreviated fourth day of the week (Wed) */
   #define ABDAY_5   12  /* abbreviated fifth day of the week (Thu) */
   #define ABDAY_6   13  /* abbreviated sixth day of the week (Fri) */
   #define ABDAY_7   14  /* abbreviated seventh day of the week (Sat) */

   #define DAY_1     15  /* name of the first day of the week (Sunday) */
   #define DAY_2     16  /* name of the second day of the week (Monday) */
   #define DAY_3     17  /* name of the third day of the week (Tuesday) */
   #define DAY_4     18  /* name of the fourth day of the week (Wednesday) */
   #define DAY_5     19  /* name of the fifth day of the week (Thursday) */
   #define DAY_6     20  /* name of the sixth day of the week (Friday) */
   #define DAY_7     21  /* name of the seventh day of the week (Saturday) */

   #define ABMON_1   22  /* abbreviated first month (Jan) */
   #define ABMON_2   23  /* abbreviated second month (Feb) */
   #define ABMON_3   24  /* abbreviated third month (Mar) */
   #define ABMON_4   25  /* abbreviated fourth month (Apr) */
   #define ABMON_5   26  /* abbreviated fifth month (May) */
   #define ABMON_6   27  /* abbreviated sixth month (Jun) */
   #define ABMON_7   28  /* abbreviated seventh month (Jul) */
   #define ABMON_8   29  /* abbreviated eighth month (Aug) */
   #define ABMON_9   30  /* abbreviated ninth month (Sep) */
   #define ABMON_10  31  /* abbreviated tenth month (Oct) */
   #define ABMON_11  32  /* abbreviated eleventh month (Nov) */
   #define ABMON_12  33  /* abbreviated twelveth month (Dec) */

   #define MON_1     34  /* name of the first month (January) */
   #define MON_2     35  /* name of the second month (February) */
   #define MON_3     36  /* name of the third month (March) */
   #define MON_4     37  /* name of the fourth month (April) */
   #define MON_5     38  /* name of the fifth month (May) */
   #define MON_6     39  /* name of the sixth month (June) */
   #define MON_7     40  /* name of the seventh month (July) */
   #define MON_8     41  /* name of the eighth month (August) */
   #define MON_9     42  /* name of the ninth month (September) */
   #define MON_10    43  /* name of the tenth month (October) */
   #define MON_11    44  /* name of the eleventh month (November) */
   #define MON_12    45  /* name of the twelfth month (December) */

   #define RADIXCHAR 46  /* radix character */
   #define THOUSEP   47  /* separator for thousands */
   #define YESEXPR   48  /* affirmative response for yes/no queries */
   #define NOEXPR    49  /* negative response for yes/no queries */
   #define CRNCYSTR  50  /* currency symbol; - leading, + trailing */

   #ifndef __NL_NUM_ITEMS
   #define __NL_NUM_ITEMS 51
   #endif
   /**********
   ** if this number changes, it MUST be changed
   ** in localdef.h
   **********/

   extern char *_IMPORT _LNK_CONV nl_langinfo(nl_item);
   #if (__IBMC__ || __IBMCPP__) && __LIBANSI__
      #pragma isolated_call(nl_langinfo)
   #endif

   #if __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif

