// Revision: 00 1.38.1.22 source/ui/baseapp/iwindow.hpp, basewin, ioc.v400, 001006 
#ifndef _IWINDOW_
#define _IWINDOW_
/*******************************************************************************
* FILE NAME: iwindow.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IWindow                                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibidiset.hpp>
#include <ibitflag.hpp>
#include <ievent.hpp>
#include <ihandle.hpp>
#include <iintrst.hpp>
#include <inotify.hpp>
#include <ipoint.hpp>

#ifdef IC_MOTIF
#include <Xm/Text.h>
#include <iarglist.hpp>
#endif
#include <iuipl.hpp>

#ifdef IC_MOTIF
union  _XEvent;
struct _WidgetRec;

extern "C" {
  typedef _WidgetRec *  (*IXmCreateFunction) ( _WidgetRec*,
                                               char*,
                                               void*,
                                               unsigned int );
}
#endif //IC_MOTIF
#ifdef IC_WIN
struct HWND__;

 #ifdef IC_WIN_STRICT
extern "C" {
  extern void* __stdcall _pfnwpICWinProc ( struct HWND__*,
                                           unsigned long,
                                           void*,
                                           void* );
}
 #else
extern "C" {
  extern void* __stdcall _pfnwpICWinProc ( void*,
                                           unsigned long,
                                           void*,
                                           void* );
}
 #endif
#endif // IC_WIN
#ifdef IC_PM
extern "C" {
  extern void* _System _pfnwpICWinProc ( unsigned long,
                                         unsigned long,
                                         void*,
                                         void* );
}
#endif // IC_PM

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IAcceleratorTable;
class IAccelTblHandle;
class IAttribute;
class IAttributeName;
class IChildCursorData;
class IColor;
class IDMItemProvider;
class IException;
class IFont;
class IHandler;
class INotificationEvent;
class IRectangle;
class IString;
class IWindowAttributeCursorData;
class IWindowBidiData;
class IWindowData;
class IWindowNotifyHandler;
class IWindowPrivateData;

#ifndef IC_BUILD
class IWindow;
inline unsigned long const &key(IWindow* const& window);
#endif

#pragma enum(4)
#pragma pack(push,4)

class IWindow : public INotifier {
typedef INotifier
  Inherited;

public:
typedef unsigned long
  DataHandle;
/*------------------------------- Constructors -------------------------------*/
  IWindow ( unsigned long        identifier,
            IWindow*             parent );
  IWindow ( const IWindowHandle& handle );

virtual
 ~IWindow ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0( Style, IWindow );
static const Style
  IC_IMPORTU noStyle,
  IC_IMPORTU visible,
  IC_IMPORTU disabled,
  IC_IMPORTU clipChildren,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU clipToParent,
  IC_IMPORTU saveBits,
  IC_IMPORTU synchPaint,
#endif
#ifndef IC_MOTIF_FLAGNOP
  IC_IMPORTU group,
  IC_IMPORTU tabStop,
#endif
  IC_IMPORTU clipSiblings,
  IC_IMPORTU leftToRight,
  IC_IMPORTU rightToLeft;

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool            extendedOnly = false ) const;
#ifdef IC_MOTIF
virtual IArgList
  convertToArgList ( const IBitFlag& style ) const;
#endif

/*---------------------------- Window Positioning ----------------------------*/
virtual IWindow
 &moveTo     ( const IPoint&     newPosition ),
 &sizeTo     ( const ISize&      newSize ),
 &moveSizeTo ( const IRectangle& newSizeAndPosition );

virtual IPoint
  position   ( ) const;

virtual ISize
  parentSize ( ) const,
  size       ( ) const;

virtual IRectangle
  nativeRect ( ) const,
  rect       ( ) const;

static ISize
  parentSize ( const IWindowHandle& windowHandle );

/*-------------------------------- Attributes --------------------------------*/
virtual IWindow
 &setOwner                  ( const IWindow* newOwner ),
#ifdef IC_PMWIN
 &setParent                 ( const IWindow* newParent ),
#endif
#ifndef IC_MOTIF_FLAGNOP
 &setId                     ( unsigned long  newIdentifier ),
#endif
 &enable                    ( bool           enableWindow = true ),
 &disable                   ( ),
 &setFocus                  ( );

IWindow
 &setHelpId                 ( unsigned long  helpTopicId );

IWindow
 *parent                    ( ) const;

virtual IWindow
 *owner                     ( ) const;

bool
  isEnabled                 ( ) const;

virtual bool
  hasFocus                  ( ) const,
  isValid                   ( ) const,
  isFrameWindow             ( ) const;

static IWindow
 *desktopWindow             ( );

static IWindow
 *objectWindow              ( );

virtual IWindowHandle
  handle                    ( ) const,
  handleForChildCreation    ( ) const;


static IWindow
 *windowWithHandle          ( const IWindowHandle& windowHandle,
                              bool                 allThreads = true ),
 *windowWithOwner           ( unsigned long        identifier,
                              const IWindow*       owner,
                              bool                 allThreads = true ),
 *windowWithParent          ( unsigned long        identifier,
                              const IWindow*       parent,
                              bool                 allThreads = true );

static IWindowHandle
  handleWithParent          ( unsigned long        identifier,
                              const IWindowHandle& parent );

static bool
  isWindowValid             ( const IWindow*       window );

#ifndef IC_MOTIF_NOP
static IWindowHandle
  handleWithPointerCaptured ( );
#endif

virtual unsigned long
  id                        ( ) const;

unsigned long
  helpId                    ( ) const;

IMessageQueueHandle
  messageQueue              ( ) const;

/*--------------------------- Tab Stops and Groups ---------------------------*/
virtual IWindow
 &enableGroup    ( bool enable = true ),
 &disableGroup   ( );
virtual bool
  isGroup        ( ) const;
#ifndef IC_MOTIF_FLAGNOP
virtual IWindow
 &enableTabStop  ( bool enable = true ),
 &disableTabStop ( );
virtual bool
  isTabStop      ( ) const;
#endif

/*------------------------- Capturing Pointer Events -------------------------*/
virtual IWindow
 &capturePointer     ( bool capture = true ),
 &releasePointer     ( );

virtual bool
  hasPointerCaptured ( ) const;

/*--------------------------- Pointer Positioning ----------------------------*/
static void
  movePointerTo   ( const IPoint& position );

static IPoint
  pointerPosition ( );

/*--------------------------- DataHandle Functions ---------------------------*/
static DataHandle
  dataHandleWithKey( const char* dataKeyName );
IWindow&
  adoptWindowData( const DataHandle& typeToken, IWindowData* windowData );
IWindowData*
  windowData (const DataHandle& typeToken) const;

/*------------------------------ Sibling Order -------------------------------*/
enum SiblingOrder {
  onTopOfSiblings,
  behindSiblings
  };

virtual IWindow
 &positionBehindSiblings ( ),
 &positionOnSiblings     ( ),
 &positionBehindSibling  ( const IWindowHandle& siblingWindow );

static void
 setDefaultOrdering      ( SiblingOrder         order );
static SiblingOrder
 defaultOrdering         ( );
/*---------------------------- Paint Support----------------------------------*/
virtual IRectangle
  invalidatedRect() const;
virtual IRegionHandle
  invalidatedRegion() const;

virtual IWindow
 &validateRect( const IRectangle &validatedRectangle);
virtual IWindow
 &validateRegion( const IRegionHandle &validatedRegion);

/*--------------------------- Event Send and Post ----------------------------*/
enum EventType {
  command=1,
  systemCommand,
  control,
  help,
  character
  };

virtual const IWindow
 &postEvent ( unsigned long           eventId,
              const IEventParameter1& parm1 = 0,
              const IEventParameter2& parm2 = 0 ) const,
 &postEvent ( const IEvent&           event )     const,
 &postEvent ( EventType               eventType,
              const IEventParameter1& parm1 = 0,
              const IEventParameter2& parm2 = 0 ) const;

virtual IEventResult
  sendEvent ( unsigned long           eventId,
              const IEventParameter1& parm1 = 0,
              const IEventParameter2& parm2 = 0 ) const,
  sendEvent ( const IEvent&           event )     const,
  sendEvent ( EventType               eventType,
              const IEventParameter1& parm1 = 0,
              const IEventParameter2& parm2 = 0 ) const;

/*----------------------------- Window Painting ------------------------------*/
enum RefreshType {
  paintAll,
  immediate,
  paintAllImmediate
  };

virtual IWindow
 &show               ( bool              showWindow = true ),
 &hide               ( ),
 &enableUpdate       ( bool              enableWindow = true ),
#ifndef IC_MOTIF_FLAGNOP
 &disableUpdate      ( ),
#endif
 &refresh            ( RefreshType       type = paintAll ),
 &refresh            ( const IRectangle& invalidRectangle,
                       bool              immediate = false ),
 &showSourceEmphasis ( bool              show = true ),
 &hideSourceEmphasis ( );

bool
  isVisible          ( ) const,
  isShowing          ( ) const,
  isUpdateEnabled    ( ) const;

virtual IPresSpaceHandle
  presSpace          ( ) const;

virtual void
  releasePresSpace   ( const IPresSpaceHandle& presentationSpaceHandle ) const;

/*------------------------- Accelerator Key Support --------------------------*/
IWindow
 &setAcceleratorTable  ( const IAcceleratorTable* acceleratorTable ),
 &setAcceleratorHandle ( const IAccelTblHandle&   handle );

IAcceleratorTable
  acceleratorTable     ( ) const;
IAccelTblHandle
  acceleratorHandle    ( ) const;

/*----------------------------- Object Deletion ------------------------------*/
IWindow
 &setAutoDeleteObject  ( bool autoDelete = true ),
 &setAutoDestroyWindow ( bool autoDestroy = false );

bool
  isAutoDeleteObject   ( ) const,
  isAutoDestroyWindow  ( ) const;

/*-------------------------- Drag and Drop Support ---------------------------*/
IDMItemProvider
 *itemProvider    ( ) const;

IWindow
 &setItemProvider ( IDMItemProvider* dragProvider );

private:
	bool setFontImp(IFont& font);
#ifdef IC_MOTIF
	void ifontSetRCFontList( IWindow* piwParent, Widget rc, XmFontList fontList );
	void ifontSetChildFontList( IWindow* pwin, Widget root, XmFontList fontList );
	void ifontSetWidgetFontList(IWindow* piwParent,Widget current,XmFontList fontList);
#endif //IC_MOTIF
public:

class ChildCursor  {
public:
/*------------------------------- Constructors -------------------------------*/
  ChildCursor ( IWindow& parent,
                bool     onlyIWindowChildren = false );
virtual
 ~ChildCursor ( );

/*----------------------------- Cursor Functions -----------------------------*/
virtual bool
  setToFirst ( ),
  setToNext  ( ),
  isValid    ( ) const;

virtual void
  invalidate ( );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  ChildCursor ( const ChildCursor& cursor );
ChildCursor
 &operator =  ( const ChildCursor& cursor );

/*--------------------------------- Private ----------------------------------*/
friend class IWindow;

IChildCursorData
 *pCursorData;

IWindowHandle
  hwnd;
}; // IWindow::ChildCursor

/*--------------------------- Child Cursor Support ---------------------------*/
IWindowHandle
  childAt       ( const ChildCursor& cursor ) const;
IWindow
 *childWindowAt ( const ChildCursor& cursor ) const;

/*------------------------------ Canvas Support ------------------------------*/
virtual IWindowHandle
  defaultPushButton      ( ) const,
  defaultEmphasisButton  ( ) const,
  matchForMnemonic       ( unsigned short character ) const;

enum Layout {
  windowCreated=1,
  colorChanged=2,
  sizeChanged=4,
  minimumSizeChanged=8,
  childMinimumSizeChanged=16,
  fontChanged=32,
  fontPropogated=64,
  layoutChanged=128,
  immediateUpdate=256,
  childWindowCreated=512,
  windowDestroyed=1024,
  childWindowDestroyed=2048
  };

virtual IWindow
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

virtual bool
  isLayoutDistorted  ( unsigned long layoutAttribute ) const;

IWindow
 &resetMinimumSize   ( ),
 &setMinimumSize     ( const ISize& size );

ISize
  minimumSize        ( bool windowCalculatedSize = false ) const;

virtual IRectangle
  layoutAdjustment   ( ) const,
  visibleRectangle   ( ) const;

IWindow
 &enableMinimumSizeCaching    ( bool enableCaching = true ),
 &disableMinimumSizeCaching   ( );
bool
  isMinimumSizeCachingEnabled ( ) const;

/*------------------------------ Miscellaneous -------------------------------*/
static IPoint
  mapPoint ( const IPoint&        point,
             const IWindowHandle& from,
             const IWindowHandle& to );

/*------------------------------- Diagnostics --------------------------------*/
virtual IString
  asString    ( ) const,
  asDebugInfo ( ) const;

class ExceptionFn  {
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~ExceptionFn ( );

/*--------------------------- Exception Processing ---------------------------*/
virtual bool
  handleException ( IException& dispatcherException,
                    IEvent&     exceptionEvent ) = 0;
}; // IWindow::ExceptionFn


/*--------------------------- Exception Processing ---------------------------*/
static IWindow::ExceptionFn
 *setExceptionFunction ( IWindow::ExceptionFn* exceptionFunction ),
 *exceptionFunction    ( );

virtual bool
  handleException      ( IException& dispatcherException,
                         IEvent&     exceptionEvent );

/*----------------------------- Color Functions ------------------------------*/
virtual IColor
  foregroundColor              ( ) const,
  backgroundColor              ( ) const,
  shadowColor                  ( ) const,
  disabledForegroundColor      ( ) const,
  disabledBackgroundColor      ( ) const,
  hiliteForegroundColor        ( ) const,
  hiliteBackgroundColor        ( ) const,
  activeColor                  ( ) const,
  inactiveColor                ( ) const;

virtual IWindow
 &setForegroundColor           ( const IColor& color ),
 &setBackgroundColor           ( const IColor& color );
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IWindow
 &setShadowColor               ( const IColor& color ),
 &setDisabledForegroundColor   ( const IColor& color ),
 &setDisabledBackgroundColor   ( const IColor& color ),
 &setHiliteForegroundColor     ( const IColor& color ),
 &setHiliteBackgroundColor     ( const IColor& color ),
 &setActiveColor               ( const IColor& color ),
 &setInactiveColor             ( const IColor& color );
#endif // !IC_MOTIFWIN_FLAGNOP

virtual IWindow
 &resetForegroundColor         ( ),
 &resetBackgroundColor         ( );
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IWindow
 &resetShadowColor             ( ),
 &resetDisabledForegroundColor ( ),
 &resetDisabledBackgroundColor ( ),
 &resetHiliteForegroundColor   ( ),
 &resetHiliteBackgroundColor   ( ),
 &resetActiveColor             ( ),
 &resetInactiveColor           ( );
#endif // !IC_MOTIFWIN_FLAGNOP

/*------------------------------ Font Functions ------------------------------*/
virtual IWindow
 &setFont       ( const IFont& font );

#ifndef IC_MOTIF_FLAGNOP
virtual IWindow
 &resetFont     ( );
#endif

virtual IFont
  font          ( ) const;

ISize
  characterSize ( ) const;

/*-------------------------- Observer Notification ---------------------------*/
virtual IWindow
 &enableNotification       ( bool enable = true ),
 &disableNotification      ( );

virtual bool
  isEnabledForNotification ( ) const;

virtual IWindow
 &notifyObservers          ( const INotificationEvent& event ),
 &notifyObserversAsync     ( const INotificationEvent& event );

virtual INotifierAddress
  notifierAddress          ( ) const;

/*------------------------------ Notifications -------------------------------*/
static INotificationId const
  IC_IMPORTU sizeId,
  IC_IMPORTU positionId,
  IC_IMPORTU visibleId,
  IC_IMPORTU enableId,
  IC_IMPORTU focusId,
  IC_IMPORTU foregroundColorId,
  IC_IMPORTU backgroundColorId,
#ifndef IC_MOTIFWIN_FLAGNOP
  IC_IMPORTU borderColorId,
  IC_IMPORTU shadowColorId,
  IC_IMPORTU disabledForegroundColorId,
  IC_IMPORTU disabledBackgroundColorId,
  IC_IMPORTU activeColorId,
  IC_IMPORTU inactiveColorId,
  IC_IMPORTU hiliteForegroundColorId,
  IC_IMPORTU hiliteBackgroundColorId,
#endif
  IC_IMPORTU fontId,
  IC_IMPORTU commandId,
  IC_IMPORTU systemCommandId,
  IC_IMPORTU attributeAddReplaceId,
  IC_IMPORTU attributeRemoveId;

/*---------------------- Event Handling Implementation -----------------------*/
bool
  dispatchRemainingHandlers ( IEvent& event,
                              bool    callDefProc = true );

/*------------------------ Selective Event Processing ------------------------*/
INESTEDBITFLAGCLASSDEF0( EventMask, IWindow );
static const EventMask
  IC_IMPORTU someMouseMoves,
  IC_IMPORTU allMouseMoves,
  IC_IMPORTU mouseEntersLeaves;

IWindow
 &startHandling ( const EventMask& events ),
 &stopHandling  ( const EventMask& events );
bool
  isHandling    ( const EventMask& events ) const;

/*------------------------------ Mouse Pointer -------------------------------*/
virtual IPointerHandle
  mousePointer    ( ) const;

virtual IWindow
 &setMousePointer ( const IPointerHandle& mousePointer );

/*------------------------------- Nested Types -------------------------------*/
class AttributeCursor {
  public:
  /*------------------------------ Constructors ------------------------------*/
    AttributeCursor ( IWindow& win );
   ~AttributeCursor ( );

  /*---------------------------- Cursor Functions ----------------------------*/
  virtual bool
    setToFirst ( ),
    setToNext  ( ),
    isValid    ( ) const;
  virtual void
    invalidate ( );

  IAttributeName
    attributeName ( ) const;
  const IAttribute
   *attribute     ( ) const;
  private:
  /*---------------------------- Hidden Functions ----------------------------*/
    AttributeCursor ( const AttributeCursor& cursor );
  AttributeCursor
   &operator=       ( const AttributeCursor& cursor );

  /*-------------------------------- Private ---------------------------------*/
  IWindow
   *fWindow;
  IWindowAttributeCursorData
   *fData;
}; // IWindow::AttributeCursor

/*---------------------------- Window Attributes -----------------------------*/
enum ESearchType
{
  kWindowOnly,
  kWindowAndParents
};

IWindow
 &addOrReplaceAttribute ( const IAttributeName&  name,
                          const IAttribute&      attribute ),
 &removeAttribute       ( const IAttributeName&  name ),
 &removeAllAttributes   ( );

const IAttribute
 *attributeWithName     ( const IAttributeName&  name,
                          ESearchType            search = kWindowOnly ) const;

IAttributeName
  attributeNameAt       ( const AttributeCursor& cursor ) const;

protected:
/*------------------------------ Implementation ------------------------------*/
#ifdef IC_PMWIN
virtual IWindowHandle
  create           ( unsigned long         id,
                     const char*           text,
                     unsigned long         style,
                     const char*           windowClass,
                     const IWindowHandle&  parent,
                     const IWindowHandle&  owner,
                     const IRectangle&     initRect,
                     const void*           ctlData,
                     const void*           presParams,
                     IWindow::SiblingOrder ordering = defaultOrdering(),
                     unsigned long         extendedStyle = 0 );
virtual IWindowHandle
  create           ( unsigned long         id,
                     const char*           text,
                     const IBitFlag&       style,
                     const char*           windowClass,
                     const IWindow*        parent,
                     const IWindow*        owner,
                     const IRectangle&     initRect,
                     const void*           ctlData,
                     const void*           presParams,
                     IWindow::SiblingOrder ordering = defaultOrdering() );
#endif // IC_PMWIN

#ifdef IC_MOTIF
virtual IWindowHandle
  create           ( unsigned long         id,
                     const char*           text,
                     unsigned long         style,
                     IXmCreateFunction     createFunction,
                     const IWindowHandle&  parent,
                     const IWindowHandle&  owner,
                     const IRectangle&     initRect,
                     const void*           callerArgList,
                     unsigned int          callerNumberArguments,
                     IWindow::SiblingOrder ordering = defaultOrdering(),
                     unsigned long         extendedStyle = 0 );

virtual IWindowHandle
  create           ( unsigned long         id,
                     const char*           text,
                     const IBitFlag&       style,
                     IXmCreateFunction     createFunction,
                     const IWindow*        parent,
                     const IWindow*        owner,
                     const IRectangle&     initRect,
                     IWindow::SiblingOrder ordering = defaultOrdering() );
virtual IWindow
 &prepareForUse    ( const IWindowHandle&  windowHandle );
#endif  //IC_MOTIF

IWindow
 &addHandler       ( IHandler* newHandler ),
 &removeHandler    ( IHandler* oldHandler );

bool
  isPrimaryWindow  ( ) const;

IWindow
 &bindMessageQueue ( bool bindToMessageQueue = true ),
 &unbindMessageQueue ( );

bool
  isBoundToMessageQueue ( ) const;

virtual IWindow
 &setColor         ( unsigned long colorArea,
                     const IColor& color ),
 &resetColor       ( unsigned long colorArea );

virtual IWindow
 &setStyle         ( unsigned long style ),
 &setExtendedStyle ( unsigned long extendedStyle );

virtual unsigned long
  style            ( ) const,
  extendedStyle    ( ) const;

IColor
  color            ( unsigned long colorArea ) const,
  color            ( unsigned long colorArea,
                     const IColor& defaultColor ) const;
#ifdef IC_PMWIN
unsigned short
  windowUShort     ( long index ) const;

unsigned long
  windowULong      ( long index ) const;

IWindow
 &setWindowData    ( long           index,
                     unsigned short dataValue ),
 &setWindowData    ( long           index,
                     unsigned long  dataValue );
#endif // IC_PMWIN

IWindow
  &reserveUserWindowWord   ( bool reserve = true );
bool
  isUserWindowWordReserved ( ) const;

/*-------------------------- Protected Constructors --------------------------*/
  IWindow ( );

/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize  ( ) const;
IWindow
 &saveMinimumSize  ( const ISize& size );
ISize
  savedMinimumSize ( ) const;

/*---------------------- Event Handling Implementation -----------------------*/
IWindow
 &startHandlingEventsFor ( const IWindowHandle& windowHandle ),
 &startHandlingEventsFor ( unsigned long        identifier,
                           IWindow*             parent );
static void
  addToWindowSet         ( IWindow*             window,
                           const IWindowHandle& windowHandle ),
  removeFromWindowSet    ( IWindow*             window );

bool
  dispatch               ( IEvent& event );

IWindow
 &defaultProcedure       ( IEvent& event );

bool
  deleteIsInProcess      ( ) const;

#ifdef IC_MOTIFWIN
virtual bool
  passEventToOwner       ( IEvent &event );
#endif  //IC_MOTIFWIN

/*------------------- Observer Notification Implementation -------------------*/
virtual IWindow
 &addObserver            ( IObserver&             observer,
                           const IInterest&       interest ),
 &removeObserver         ( IObserver&             observer ),
 &removeObserver         ( IObserver&             observer,
                           const IInterest&       interest ),
 &removeAllObservers     ( );

IObserverList
 &observerList           ( const IInterest*       interest = 0 ) const;

IWindow
 &setNotificationHandler ( IWindowNotifyHandler*  notifyHandler );

IWindowNotifyHandler
 *notificationHandler    ( ) const;

virtual IWindow
 &notifyObservers        ( const INotificationId& notification );

/*--------------------------- Default Button Support -------------------------*/
virtual IWindow
 &setDefaultPushButton     ( const IWindowHandle& defaultPushButton ),
 &setDefaultEmphasisButton ( const IWindowHandle& defaultEmphasisButton,
                             bool                 enable);

/*-------------------------- Drag and Drop Support ---------------------------*/
#ifdef IC_WIN
virtual bool
  isDragStarting ( IEvent &event );
#endif

#ifdef IC_PMWIN
/*---------------------- Bidirectional Language Support ----------------------*/
virtual IWindow
 &setBidiSettings ( const IBidiSettings& bidiSettings,
                    bool                 childInherit,
                    bool                 refresh );
#endif

private:
/*----------------------------- Hidden Functions -----------------------------*/
IWindow     ( const IWindow& window );
IWindow
 &operator= ( const IWindow& window );

/*--------------------------------- Private ----------------------------------*/
friend class IApplication;
friend class IBidiSettings;
friend class ICurrentThreadData;
friend class IDMDragHandler;
friend class IHandle;
friend class IWindowHandle;
friend class IHandler;
friend class IFileDialog;
friend class IFontDialog;
friend class IFont;
friend class IMenu;
friend class IMenuBar;
friend class IMessageHandler;
friend class IPopUpMenu;
friend class ISystemMenu;
friend class ISubmenu;
friend class IWindow::AttributeCursor;
friend class IWindowPrivateData;

enum State {
  autoDeleteObject=1,
  autoDestroyWindow=2,
  deleteInProcess=4,
  primaryWindow=8,
  addedToList=16,
  dispatchInProcess=32,
  needsDelete=64,
  updateRHtInProgress=128,
  boundToMessageQueue=256,
  forgetBitGravity=512,
  fontWasSet=1024,
  bkgndColorWasSet=2048,
  frgndColorWasSet=4096,
  cacheMinimumSize=8192,
  useFastHandleProc=16384
  };

friend unsigned long const
 &key             ( IWindow* const& window );

#ifdef IC_PM
friend void* _System
  _pfnwpICWinProc ( unsigned long hwnd,
                    unsigned long ulMsg,
                    void*         mp1,
                    void*         mp2 );
#endif

#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
friend void* __stdcall
  _pfnwpICWinProc ( struct HWND__* hwnd,
                    unsigned long  ulMsg,
                    void*          mp1,
                    void*          mp2 );
 #else
friend void* __stdcall
  _pfnwpICWinProc ( void*         hwnd,
                    unsigned long ulMsg,
                    void*         mp1,
                    void*         mp2 );
 #endif
#endif // IC_WIN

#ifdef   IC_MOTIF
friend void _System
  iwindowXEventCallback               ( _WidgetRec* w,
                                        void*       client_data,
                                        _XEvent*    event,
                                        char*       continue_to_dispatch ),
  iwindowMotifCallback                ( _WidgetRec* w,
                                        void*       client_data,
                                        void*       call_data ),
  iwindowSashCallback                 ( _WidgetRec* w,
                                        void*       client_data,
                                        void*       call_data ),
  iwindowDestroyCallback              ( _WidgetRec* w,
                                        void*       client_data,
                                        void*       call_data ),
  iwindowRelatedHandleDestroyCallback ( _WidgetRec* w,
                                        void*       client_data,
                                        void*       call_data ),
  ientryfMotifCallback                ( _WidgetRec* w,
                                        void*       client_data,
                                        void*       call_data ),
  imleMotifCallback                   ( _WidgetRec* w,
                                        void*       client_data,
                                        void*       call_data ),
  imenuMotifCallback                  ( _WidgetRec* w,
                                        void*       client_data,
                                        void*       call_data ),
  imenuXEventCallback                 ( _WidgetRec* w,
                                        void*       client_data,
                                        _XEvent*    event,
                                        char*       continue_to_dispatch ),
  iClipboardDelayedRenderingCallback  ( _WidgetRec* w,
                                        long*       dataId,
                                        long*       privateId,
                                        int*        reason);

friend class IDMMotif;
#endif // IC_MOTIF

static void
  cleanUpHandler          ( IHandler& handler );

#ifdef IC_WIN
static bool
  useRealCoordinates      ( const IWindow* window );
#endif

IWindow
 &setDeleteInProcess      ( ),
 &cleanUp                 ( );

bool
  dispatchCleanup         ( IEvent& event,
                            bool    nested );

IWinProc
 *setDefaultProcedure     ( IWinProc* newDefProc );

IWindowData
  **windowDataArray;
unsigned long
  ulWindowDataArraySize;

IWindowPrivateData
 *pWindowData;

unsigned long
  hwnd;

void
  checkForPrimaryWindow ( const IWindowHandle& hwndParent,
                          const IWindowHandle& hwndOwner );

#ifdef IC_MOTIFWIN
void
  propagateColorToChildren ( unsigned long colorArea,
                             const IColor& color );
#endif

bool
  isHandling ( unsigned long events ) const;

/*----------------------------- Obsolete Members -----------------------------*/
#ifdef IC_PMWIN
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
public:
class BidiSettings;

bool
  isBidiSupported ( ) const;

enum BidiTextType {
  visual,
  implicit
  };

enum BidiTextOrientation {
  textLeftToRight,
  textRightToLeft,
  textContextual
  };

enum BidiLayout {
  layoutLeftToRight,
  layoutRightToLeft
  };

enum BidiNumeralType {
  arabic,
  asStored,
  national,
  contextual
  };

enum BidiTextShape {
  displayShaped,
  saveShaped,
  nominalShape,
  initialShape,
  middleShape,
  finalShape,
  isolatedShape
  };

virtual IWindow
 &applyBidiSettings ( const BidiSettings& settings,
                      bool                childInherit = true,
                      bool                refresh      = true );

class BidiSettings {
public:
  BidiSettings ( const IWindow& window );

virtual
 ~BidiSettings ( );

virtual BidiSettings
 &setTextType                   ( BidiTextType        textType ),
 &setTextOrientation            ( BidiTextOrientation textOrientation ),
 &setWindowLayout               ( BidiLayout          windowLayout ),
 &setNumeralDisplay             ( BidiNumeralType     numeralDisplay ),
 &enableSymmetricSwapping       ( bool                enable = true ),
 &disableSymmetricSwapping      ( ),
 &enableWordByWordReordering    ( bool                enable = true ),
 &disableWordByWordReordering   ( ),
 &setTextShape                  ( BidiTextShape       textShape );

BidiTextType
  textType                      ( ) const;
BidiTextOrientation
  textOrientation               ( ) const;
BidiLayout
  windowLayout                  ( ) const;
BidiNumeralType
  numeralDisplay                ( ) const;
bool
  isSymmetricSwappingEnabled    ( ) const;
bool
  isWordByWordReorderingEnabled ( ) const;
BidiTextShape
  textShape                     ( ) const;

private:
friend class IWindow;
  BidiSettings ( const BidiSettings& settings );
BidiSettings
 &operator=    ( const BidiSettings& settings );
IBidiSettings
 *fBidiSettings;
}; // IWindow::BidiSettings

private:
friend class IWindow::BidiSettings;
#endif // IC_OBSOLETE
#endif // IC_PMWIN

/*----------------------- Obsolete Data and Functions ------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
/*---------------------------- Compound Controls -----------------------------*/
#ifdef IC_MOTIF
virtual IWindowHandle
  topHandle ( ) const;
/*--------------------- Compound Control Implementation ----------------------*/
virtual bool
  isRelatedHandle                  ( const IWindowHandle& windowHandle ) const;

static void
  addRelatedHandleToWindowSet      ( IWindow*             window,
                                     const IWindowHandle& windowHandle ),
  removeRelatedHandleFromWindowSet ( IWindow*             window,
                                     const IWindowHandle& windowHandle );
#endif

virtual IColor
  borderColor                  ( ) const;
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IWindow
 &resetBorderColor             ( ),
 &setBorderColor               ( const IColor& color );
#endif // !IC_MOTIFWIN_FLAGNOP

static void
  enableFastWindowWithHandle    ( bool enable = true );
static bool
  isFastWindowWithHandleEnabled ( );

protected:
virtual IWindow
 &addObserver            ( IObserver&        observer,
                           const IEventData& userData = IEventData(0) );
#endif // IC_OBSOLETE

}; // IWindow

class IWindowData {
public:
virtual
 ~IWindowData ( );
protected:
  IWindowData ( );
}; // IWindowData

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iwindow.inl>

#include <imngpres.hpp>

#endif /* _IWINDOW_ */
