// ----------------------------------------------------------------------------
//  FILE NAME: iobservr.inl
//
//  DESCRIPTION:
//   This file contains the definition of the inline functions for the
//   classes declared in iobservr.inl
//
//  COPYRIGHT:
//   IBM Open Class Library
//   Licensed Material - Property of IBM
//   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.
//
// Revision: 47 1.7.2.4 source/core/base/iobservr.inl, notification, ioc.v400, 001006 
// ----------------------------------------------------------------------------

#ifndef _IOBSERVR_INL_
#define _IOBSERVR_INL_

#ifndef IC_BUILD
#define __IOC_INLINE inline
#else
#define __IOC_INLINE
#endif

//IObserverConnectionTo
template<class ATarget>
inline
IObserverConnectionTo<ATarget>::IObserverConnectionTo( ATarget& target,
                                                       MemberFunction memberFunction )
    : fTarget(target), fConnectedMember(memberFunction)
{
}

// Bogus copy constructor, can notbe accessed, here to avoid build errors only.
template<class ATarget>
inline
IObserverConnectionTo<ATarget>::IObserverConnectionTo(
                                        const IObserverConnectionTo<ATarget> &source)
    : fTarget(source.fTarget), fConnectedMember(source.fConnectedMember)
{
}

template<class ATarget>
__IOC_INLINE
IObserverConnectionTo<ATarget>::~IObserverConnectionTo()
{
}

template<class ATarget>
__IOC_INLINE
IObserverConnectionTo<ATarget>&
IObserverConnectionTo<ATarget>::dispatchNotificationEvent(const INotificationEvent& event)
{
    (fTarget.*fConnectedMember)(event);
    return *this;
}


//IObserverForConnectionTo
template<class AType, class ATarget>
inline
IObserverForConnectionTo<AType,ATarget>::IObserverForConnectionTo( ATarget& target,
                                                                                                                                   MemberFunction memberFunction ):
    fTarget(target), fConnectedMember(memberFunction)
{
}

//  Bogus copy constructor, can not be accessed, here to avoid build errors only.
template<class AType, class ATarget>
inline
IObserverForConnectionTo<AType, ATarget>::IObserverForConnectionTo(
                const IObserverForConnectionTo<AType, ATarget> &source)
   : fTarget(source.fTarget)
{
}


template<class AType, class ATarget>
inline
IObserverForConnectionTo<AType, ATarget>::~IObserverForConnectionTo()
{
}


template<class AType, class ATarget>
__IOC_INLINE
void
IObserverForConnectionTo<AType,ATarget>::dispatchOldNotificationEvent ( const INotificationEvent& event, void* edata)
{
    AType* data = (AType*) edata;
    INotificationEventFor<AType> convertedEvent(event.interest(), *data);
    ( fTarget.*fConnectedMember ) ( convertedEvent );
}

template<class AType, class ATarget>
__IOC_INLINE
IObserverForConnectionTo<AType,ATarget>&
IObserverForConnectionTo<AType,ATarget>::dispatchNotificationEvent(const INotificationEvent& event)
{
    const INotificationEventFor<AType>* dataEvent = 0;
#if     IC_RTTI_ENABLED
//Required by compiler to complete INotificationEventFor<AType> class defn mandated by dynamic_cast:

    INotificationEventFor<AType>& templ_ref_problem = (INotificationEventFor<AType>&) 0;
    templ_ref_problem = templ_ref_problem;


    dataEvent = dynamic_cast<const INotificationEventFor<AType>*> (&event);
#else
    dataEvent = ((INotificationEventFor<AType>*)&event);
#endif
    if (dataEvent != 0)
    {
        (fTarget.*fConnectedMember)(*dataEvent);
    }
    else
    {
        // Need to convert old style EventData to INotificationEventFor
        handleOldNotificationEvent(event);
    }
    return *this;
}

#endif // _IOBSERVR_INL_
