// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 69 1.6.1.4 source/core/collect/iissbst.h, collection, ioc.v400, 001006 
#ifndef _IISSBST_
#define _IISSBST_

#include <iisskss.h>
#include <iikssbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedSetOnKeySortedSetImpl
         <IKeySortedSetAsBstTreeImpl> ISortedSetAsBstTreeImpl;

typedef IASortedSetOnKeySortedSetOps
         <IKeySortedSetAsBstTreeImpl> IASortedSetAsBstTreeOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISortedSetAsBstTreeOps :
  public IASortedSetAsBstTreeOps {

  typedef  ISortedSetAsBstTreeOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsBstTreeOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedSetAsBstTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedSetAsBstTreeOps
                           (INumber);

           ISortedSetAsBstTreeOps
                           (INumber, void*);

           ISortedSetAsBstTreeOps
                           (ISortedSetAsBstTreeOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedSetAsBstTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsBstTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iissbst.c>
#endif



#pragma info (restore)


#endif // _IISSBST_
