// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 60 1.6.1.4 source/core/collect/iisrlst.h, collection, ioc.v400, 001006 
#ifndef _IISRLST_
#define _IISRLST_

#include <iisrksb.h>
#include <iiksblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedRelationOnKeySortedBagImpl
         <IKeySortedBagAsListImpl> ISortedRelationAsListImpl;

typedef IASortedRelationOnKeySortedBagOps
         <IKeySortedBagAsListImpl> IASortedRelationAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC ISortedRelationAsListOps :
  public IASortedRelationAsListOps {

  typedef  ISortedRelationAsListOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsListOps
            <Element, _Key,
             ElementOps, IKeySortedBagAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           ISortedRelationAsListOps
                           (INumber);

           ISortedRelationAsListOps
                           (INumber, void*);

           ISortedRelationAsListOps
                           (ISortedRelationAsListOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~ISortedRelationAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator IKeySortedBagAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iisrlst.c>
#endif



#pragma info (restore)


#endif // _IISRLST_
