// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 48 1.6.1.4 source/core/collect/iismlst.h, collection, ioc.v400, 001006 
#ifndef _IISMLST_
#define _IISMLST_

#include <iismkss.h>
#include <iiksslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedMapOnKeySortedSetImpl
         <IKeySortedSetAsListImpl> ISortedMapAsListImpl;

typedef IASortedMapOnKeySortedSetOps
         <IKeySortedSetAsListImpl> IASortedMapAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC ISortedMapAsListOps :
  public IASortedMapAsListOps {

  typedef  ISortedMapAsListOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsListOps
            <Element, _Key,
             ElementOps, IKeySortedSetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           ISortedMapAsListOps
                           (INumber);

           ISortedMapAsListOps
                           (INumber, void*);

           ISortedMapAsListOps
                           (ISortedMapAsListOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~ISortedMapAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator IKeySortedSetAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iismlst.c>
#endif



#pragma info (restore)


#endif // _IISMLST_
