// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 39 1.6.1.4 source/core/collect/iismbst.h, collection, ioc.v400, 001006 
#ifndef _IISMBST_
#define _IISMBST_

#include <iismkss.h>
#include <iikssbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedMapOnKeySortedSetImpl
         <IKeySortedSetAsBstTreeImpl> ISortedMapAsBstTreeImpl;

typedef IASortedMapOnKeySortedSetOps
         <IKeySortedSetAsBstTreeImpl> IASortedMapAsBstTreeOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC ISortedMapAsBstTreeOps :
  public IASortedMapAsBstTreeOps {

  typedef  ISortedMapAsBstTreeOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsBstTreeOps
            <Element, _Key,
             ElementOps, IKeySortedSetAsBstTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           ISortedMapAsBstTreeOps
                           (INumber);

           ISortedMapAsBstTreeOps
                           (INumber, void*);

           ISortedMapAsBstTreeOps
                           (ISortedMapAsBstTreeOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~ISortedMapAsBstTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator IKeySortedSetAsBstTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iismbst.c>
#endif



#pragma info (restore)


#endif // _IISMBST_
