// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 13 1.4.3.2 source/core/collect/iisetavl.c, collection, ioc.v400, 001006 
#ifndef _IISETAVL_C_
#define _IISETAVL_C_


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#ifdef IC_BUILD
#define __IOC_INLINE
#else
#define __IOC_INLINE inline
#endif

// ---
// ISetAsAvlTreeOps
// ---

// public members

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISetAsAvlTreeOps <Element, ElementOps, Implementation>::
ISetAsAvlTreeOps (INumber numberOfElements)
: ivBase (numberOfElements),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISetAsAvlTreeOps <Element, ElementOps, Implementation>::
ISetAsAvlTreeOps (INumber numberOfElements, void* opsArg)
: ivBase (numberOfElements, opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISetAsAvlTreeOps <Element, ElementOps, Implementation>::
ISetAsAvlTreeOps
  (ISetAsAvlTreeOps
    <Element, ElementOps, Implementation> const& collection)
: ivBase (collection.ivBase),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISetAsAvlTreeOps <Element, ElementOps, Implementation>::
~ISetAsAvlTreeOps ()
{
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
IACollectionImpl*
ISetAsAvlTreeOps <Element, ElementOps, Implementation>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISetAsAvlTreeOps <Element, ElementOps, Implementation>::
operator IKeySetAsAvlTreeImpl& ()
{ return *(IKeySetAsAvlTreeImpl*)ivBase ;
}

template <class Element, class ElementOps, class Implementation>
__IOC_INLINE
ISetAsAvlTreeOps <Element, ElementOps, Implementation>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl ;
}


#pragma info (restore)


#endif // _IISETAVL_C_
