// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 00 1.6.1.4 source/core/collect/iisbtab.h, collection, ioc.v400, 001006 
#ifndef _IISBTAB_
#define _IISBTAB_

#include <iisbksb.h>
#include <iiksbtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedBagOnKeySortedBagImpl
         <IKeySortedBagAsTableImpl> ISortedBagAsTableImpl;

typedef IASortedBagOnKeySortedBagOps
          <IKeySortedBagAsTableImpl> IASortedBagAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISortedBagAsTableOps :
  public IASortedBagAsTableOps {

  typedef  IASortedBagAsTableOps Inherited;

  typedef  ISortedBagAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedBagAsTableImpl > Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedBagAsTableOps
                           (INumber);

           ISortedBagAsTableOps
                           (INumber, void*);

           ISortedBagAsTableOps
                           (ISortedBagAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedBagAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iisbtab.c>
#endif



#pragma info (restore)


#endif // _IISBTAB_
