// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 91 1.6.1.4 source/core/collect/iisbdil.h, collection, ioc.v400, 001006 
#ifndef _IISBDIL_
#define _IISBDIL_

#include <iisbksb.h>
#include <iiksbdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedBagOnKeySortedBagImpl
         <IKeySortedBagAsDilTableImpl> ISortedBagAsDilTableImpl;

typedef IASortedBagOnKeySortedBagOps
          <IKeySortedBagAsDilTableImpl> IASortedBagAsDilTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISortedBagAsDilTableOps :
  public IASortedBagAsDilTableOps {

  typedef  IASortedBagAsDilTableOps Inherited;

  typedef  ISortedBagAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsDilTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedBagAsDilTableImpl > Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedBagAsDilTableOps
                           (INumber);

           ISortedBagAsDilTableOps
                           (INumber, void*);

           ISortedBagAsDilTableOps
                           (ISortedBagAsDilTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedBagAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsDilTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iisbdil.c>
#endif



#pragma info (restore)


#endif // _IISBDIL_
