// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 85 1.6.1.4 source/core/collect/iirellst.h, collection, ioc.v400, 001006 
#ifndef _IIRELLST_
#define _IIRELLST_

#include <iirelkb.h>
#include <iikblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IRelationOnKeyBagImpl
         <IKeyBagAsListImpl> IRelationAsListImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IRelationAsListOps :
  public IARelationOnKeyBagOps
          <IKeyBagAsListImpl> {

  typedef  IRelationAsListOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeyBagAsListOps
            <Element, _Key,
             ElementOps, IKeyBagAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IRelationAsListOps
                           (INumber);

           IRelationAsListOps
                           (INumber, void*);

           IRelationAsListOps
                           (IRelationAsListOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IRelationAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator IKeyBagAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iirellst.c>
#endif



#pragma info (restore)


#endif // _IIRELLST_
