// ----------------------------------------------------------------------------
// FILE NAME: iintrst.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IInterest
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Material - Property of IBM
//   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.
//
// Revision: 18 1.9.1.6 source/core/base/iintrst.hpp, notification, ioc.v400, 001006 
// ----------------------------------------------------------------------------

#ifndef _IINTRST_
#define _IINTRST_

#include <inotify.hpp>
#include <inotadr.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#ifndef IC_BUILD
inline unsigned long hash(IInterest const& k, unsigned long n);
#endif

#pragma pack(push,4)
#pragma enum(4)

class IInterest
{
public:
                        IInterest();
                        IInterest(const INotifier&, const INotificationId&);
                        IInterest(const IInterest& src);

    virtual             ~IInterest();
    INotificationId     notificationId() const;
    INotifierAddress    notifierAddress() const;
    IInterest&          operator=(const IInterest& rhs );
    bool                operator<(const IInterest& rhs) const;
    bool                operator==(const IInterest& theInterest) const;
    bool                operator!=(const IInterest& theInterest) const;
    unsigned long       hashValue() const;

    friend unsigned long hash (IInterest const& k, unsigned long n);

    virtual void        notifyObservers(INotificationEvent&);
    virtual void        notifyObserversAsync(INotificationEvent&);

protected:
    static  unsigned long computeHashValue(const char* pString);

private:
    INotificationId     fName;
    INotifierAddress    fNotifierAddress;
    unsigned long       fHashValue;
    IObserverList*      fpObserverCache;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iintrst.inl>

#endif
