// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 69 1.6.1.4 source/core/collect/iimaptab.h, collection, ioc.v400, 001006 
#ifndef _IIMAPTAB_
#define _IIMAPTAB_

#include <iimapks.h>
#include <iikstab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IMapOnKeySetImpl
         <IKeySetAsTableImpl> IMapAsTableImpl;

typedef IAMapOnKeySetOps
         <IKeySetAsTableImpl> IAMapAsAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IMapAsTableOps :
  public IAMapAsAsTableOps {

  typedef  IMapAsTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySetAsTableOps
            <Element, _Key,
             ElementOps, IKeySetAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IMapAsTableOps
                           (INumber);

           IMapAsTableOps
                           (INumber, void*);

           IMapAsTableOps
                           (IMapAsTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IMapAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements    (void const*, void const*) const;

           operator IKeySetAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iimaptab.c>
#endif



#pragma info (restore)


#endif // _IIMAPTAB_
