// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 66 1.6.1.4 source/core/collect/iimaplst.h, collection, ioc.v400, 001006 
#ifndef _IIMAPLST_
#define _IIMAPLST_

#include <iimapks.h>
#include <iikslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IMapOnKeySetImpl
         <IKeySetAsListImpl> IMapAsListImpl;

typedef IAMapOnKeySetOps
         <IKeySetAsListImpl> IAMapAsAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IMapAsListOps :
  public IAMapAsAsListOps {

  typedef  IMapAsListOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySetAsListOps
            <Element, _Key,
             ElementOps, IKeySetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IMapAsListOps
                           (INumber);

           IMapAsListOps
                           (INumber, void*);

           IMapAsListOps
                           (IMapAsListOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IMapAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements    (void const*, void const*) const;

           operator IKeySetAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iimaplst.c>
#endif



#pragma info (restore)


#endif // _IIMAPLST_
