// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 30 1.6.2.3 source/core/collect/iikssbst.c, collection, ioc.v400, 001006 
#ifndef _IIKSSBST_C_
#define _IIKSSBST_C_

#include <new.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


// -------------------------
// IKeySortedSetAsBstTreeOps
// -------------------------

// public members

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
IKeySortedSetAsBstTreeOps (INumber numberOfElements)
: Inherited (__isDTSClass (Element)),
  ivElementOps (),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
IKeySortedSetAsBstTreeOps (INumber numberOfElements, void* opsArg)
: Inherited (__isDTSClass (Element)),
  ivElementOps (opsArg),
  ivImpl (*this, numberOfElements)
{
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
IKeySortedSetAsBstTreeOps
  (IKeySortedSetAsBstTreeOps
    <Element, _Key,
     ElementOps, Implementation, nodeSize> const& collection)
: Inherited (__isDTSClass (Element)),
  ivElementOps (collection.ivElementOps),
  ivImpl (*this, collection.ivImpl)
{
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
~IKeySortedSetAsBstTreeOps ()
{
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
Assign (void* element1, void const* element2) const
{ ivElementOps.Assign (*(Element*)element1,
                       *(Element const*)element2);
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IACollectionImpl*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
Clone () const
{ return (Implementation*) *new Self (*this);
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
long
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
CompareKeys (void const* arg1, void const* arg2, IArgType argType) const
{ long comp;
  switch (argType) {
    case kElementElement: {
      comp = ivElementOps.keyOps.Compare
        (ivElementOps.Key (*(Element const*)arg1),
         ivElementOps.Key (*(Element const*)arg2));
      break;
    }
    case kElementKey: {
      comp = ivElementOps.keyOps.Compare
        (ivElementOps.Key (*(Element const*)arg1),
         IKeyForOps ((_Key const*)arg2));
      break;
    }
    case kKeyKey: {
      comp = ivElementOps.keyOps.Compare
        (IKeyForOps ((_Key const*)arg1), IKeyForOps ((_Key const*)arg2));
      break;
    }
  }
  return comp;
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
long
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
CompareKeys (void const* key, INumber index,
             void const* arg, IArgType argType) const
{ long comp;
  switch (argType) {
    case kKey: {
      comp = ivElementOps.keyOps.Compare
        (((_Key const*)key) [index], IKeyForOps ((_Key const*)arg));
      break;
    }
    case kElement: {
      comp = ivElementOps.keyOps.Compare
        (((_Key const*)key) [index],
         ivElementOps.Key (*(Element const*)arg));
      break;
    }
  }
  return comp;
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
CopyKey (void* to, INumber toIndex,
         void const* from, INumber fromIndex) const
{ ((_Key*)to) [toIndex] = ((_Key*)from) [fromIndex];
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CreateINode (void const* inode) const
{ void* node = ivElementOps.Allocate (sizeof (INode)

#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif




                                     );
  ivImpl.CheckPointer (node);

  if (inode == 0) {
    node = new (node) INode;
  }
  else {
    node = new (node) INode (*(INode*)inode);

    INumber i;
    for (i = 0; i < ((INode*)node)->ivm; i++)
      ((INode*)node)->ivPtrs [i] = ((INode*)inode)->ivPtrs [i];
    for (i = 0; i < ((INode*)node)->ivm - 1; i++)
      ((INode*)node)->ivKeys [i] = ((INode*)inode)->ivKeys [i];
  }
  return node;
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
CreateKey () const
{ return new _Key;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CreateLNode (void const* element, size_t& offset) const
{
#if __IBMCPP__ >= 400
#pragma report(level, E)
#endif
  offset = offsetof(LNode, ivElement);
#if __IBMCPP__ >= 400
#pragma report(pop)
#endif

  void* node = ivElementOps.Allocate (sizeof (LNode)

#if defined (__DEBUG_ALLOC__)
                                      , __FILE__, __LINE__
#endif




                                     );
  return
    new (ivImpl.CheckPointer (node)) LNode (*(Element const*)element);
}

#if ! defined (__INO_STREAMING__)
template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
CreateLNodeWithStreamer(IACollectionStreamer *streamer,
                        IDataStream& fromWhere) const
{ void* node = ivElementOps.Allocate (sizeof (LNode)

#if defined (__DEBUG_ALLOC__)
                                      ,__FILE__, __LINE__
#endif

                                     );
  ivImpl.CheckPointer (node);
  ((LNode*)node)->StreamIn (streamer, fromWhere);
  return node;
}
#endif

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
DeleteINode (void* inode) const
{ ((INode*)inode)->~INode ();
  ivElementOps.Deallocate (inode

#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif

                          );
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
DeleteKey (void* key) const
{ delete (_Key*)key;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
void
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
DeleteLNode (void* lnode) const
{ ((LNode*)lnode)->~LNode ();
  ivElementOps.Deallocate (lnode

#if defined (__DEBUG_ALLOC__)
                           , __FILE__, __LINE__
#endif

                          );
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
void*
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
Key (void const* element) const
{ return IKeyFromOps (ivElementOps.Key (*(Element const*)element));
}

template <class Element, class _Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, _Key,
                           ElementOps, Implementation, nodeSize>::
operator INumber () const
{ return IBSTORDER;
}

template <class Element, class Key,
          class ElementOps, class Implementation, size_t nodeSize>
IKeySortedSetAsBstTreeOps <Element, Key,
                           ElementOps, Implementation, nodeSize>::
operator Implementation* ()
{ ivImpl.CheckPointer (this);
  return &ivImpl;
}


#pragma info (restore)


#endif // _IIKSSBST_C_
