// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 13 1.6.1.4 source/core/collect/iiksdil.h, collection, ioc.v400, 001006 
#ifndef _IIKSDIL_
#define _IIKSDIL_

#include <iikskss.h>
#include <iikssdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsDilTableImpl> IKeySetAsDilTableImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsDilTableImpl> IAKeySetAsDilTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySetAsDilTableOps :
  public IAKeySetAsDilTableOps {

  typedef  IKeySetAsDilTableOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsDilTableOps
            <Element, Key,
             ElementOps, IKeySortedSetAsDilTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsDilTableOps
                           (INumber);

           IKeySetAsDilTableOps
                           (INumber, void*);

           IKeySetAsDilTableOps
                           (IKeySetAsDilTableOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsDilTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iiksdil.c>
#endif



#pragma info (restore)


#endif // _IIKSDIL_
