// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 07 1.6.1.4 source/core/collect/iiksbst.h, collection, ioc.v400, 001006 
#ifndef _IIKSBST_
#define _IIKSBST_

#include <iikskss.h>
#include <iikssbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsBstTreeImpl> IKeySetAsBstTreeImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsBstTreeImpl> IAKeySetAsBstTreeOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySetAsBstTreeOps :
  public IAKeySetAsBstTreeOps {

  typedef  IKeySetAsBstTreeOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsBstTreeOps
            <Element, Key,
             ElementOps, IKeySortedSetAsBstTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsBstTreeOps
                           (INumber);

           IKeySetAsBstTreeOps
                           (INumber, void*);

           IKeySetAsBstTreeOps
                           (IKeySetAsBstTreeOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsBstTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsBstTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iiksbst.c>
#endif



#pragma info (restore)


#endif // _IIKSBST_
