// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 80 1.5.1.6 source/core/collect/iikbhsh.h, collection, ioc.v400, 001006 
#ifndef _IIKBHSH_
#define _IIKBHSH_

#include <iiakb.h>
#include <stddef.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)






#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum (4)
#pragma pack (push,4)

struct IAKeyBagAsHshTableNodeImpl {

  IAKeyBagAsHshTableNodeImpl*
           ivNext;

           IAKeyBagAsHshTableNodeImpl
                            ();

};

template <class Element>
struct IKeyBagAsHshTableNodeImpl :
  public IAKeyBagAsHshTableNodeImpl {

  Element  ivElement;

           IKeyBagAsHshTableNodeImpl
                            (Element const&);

          ~IKeyBagAsHshTableNodeImpl
                            ();

#if ! defined(__INO_STREAMING__)
  void     StreamIn         (IACollectionStreamer*, IDataStream&);
#endif







};










class IC_EXPORTC IKeyBagAsHshTableCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  IKeyBagAsHshTableCursorImpl Self;

public:

           IKeyBagAsHshTableCursorImpl
                            (IACollectionImpl const&);

           IKeyBagAsHshTableCursorImpl
                            (IKeyBagAsHshTableCursorImpl const&);

          ~IKeyBagAsHshTableCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  bool IsInBetween      () const;

  bool IsValid          () const;

  void     operator=        (IKeyBagAsHshTableCursorImpl const&);

  bool operator==       (ICursorImpl const&) const;

protected:

private:

  IAKeyBagAsHshTableNodeImpl*
           ivNode;

  INumber  ivBucket;

  friend
  class    IKeyBagAsHshTableImpl;










};































































template <class Base>
class IKeySetOnKeyBagImpl;

class IAKeyBagAsHshTableOps;

class IC_EXPORTC IKeyBagAsHshTableImpl : public IAKeyBagImpl {

  typedef  IAKeyBagImpl Inherited;

  typedef  IKeyBagAsHshTableImpl Self;

  typedef  IAKeyBagAsHshTableNodeImpl Node;

#if ! defined (__INO_STREAMING__)
  typedef  IKeyBagAsHshTableNodeImpl<long> StreamerNode;
#endif

public:

  typedef  IAKeyBagAsHshTableOps Ops;

  typedef  IKeyBagAsHshTableCursorImpl Cursor;




  typedef  IKeyBagAsHshTableCursorImpl MngCursor;


           IKeyBagAsHshTableImpl
                            (Ops&, INumber);

           IKeyBagAsHshTableImpl
                            (Ops&, IKeyBagAsHshTableImpl const&);

          ~IKeyBagAsHshTableImpl
                            ();

  bool Add              (void const* element, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  void*    Key              (void const*) const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  bool SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     operator=        (IKeyBagAsHshTableImpl const&);

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNode       (void const*) const;

  void*    CreateNodes      (INumber) const;

  void     DeleteNode       (void*) const;

  void     DeleteNodes      (void*) const;

  bool EqualKeys        (void const*, void const*,
                             IArgType) const;

  unsigned long
           HashKey          (void const*, unsigned long,
                             IArgType) const;

private:

  enum { kOriginalVersion };
  typedef struct {
      MngCursor *cursor;
      size_t offset;
  } MngOffsetCursor;

  static
  char const*
           cvClassName;

  MngOffsetCursor*
           ivMngCursors;

  Node**   ivTable;

  INumber  ivNumberOfBuckets;

  INumber  ivNumberOfElements;

  static
  INumber& BucketOf         (ICursorImpl const&);

  void     CopyFrom         (IKeyBagAsHshTableImpl const&);

  void*    ElementOf        (Node const*) const;

  void     GrowBy           (INumber);

  static
  INumber  FindNearestPrime (INumber);

  void     Initialize       (INumber);

  static
  bool IsInBetween      (ICursorImpl const&);

  static
  INumber& NextBucketOf     (ICursorImpl const&);

  static
  Node*&   NextNodeOf       (ICursorImpl const&);

  static
  Node*&   NodeOf           (ICursorImpl const&);


  static
  Ops&     OpsOf            (IKeyBagAsHshTableImpl const&);

  void     SetInBetween     (MngCursor&) const;

  friend
  class    IKeyBagAsHshTableMngCursorImpl;

  friend
  class    IKeySetOnKeyBagImpl <Self>;

#if ! defined (__INO_STREAMING__)
protected:
  void     AddFromStream
                            (IDataStream&, ICursorImpl&);

  void*    CreateNodeWithStreamer
                              (IDataStream&) const;

public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif





































};

class IC_EXPORTC IAKeyBagAsHshTableOps {
public:

  virtual ~IAKeyBagAsHshTableOps
                             ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNode       (void const*) const = 0;

  virtual
  void*    CreateNodes      (INumber, size_t&) const = 0;

  virtual
  void     DeleteNode       (void*) const = 0;

  virtual
  void     DeleteNodes      (void*) const = 0;

  virtual
  bool EqualKeys        (void const*, void const*,
                             IArgType) const = 0;

  virtual
  unsigned long
           HashKey          (void const*, unsigned long,
                             IArgType) const = 0;

  virtual
  void*    Key              (void const*) const = 0;

protected:

           IAKeyBagAsHshTableOps
                            (bool);

private:

  bool ivContainsDTSObjects;

  friend
  class    IKeyBagAsHshTableImpl;

#if ! defined (__INO_STREAMING__)
public:
  virtual
  void*    CreateNodeWithStreamer
                            (IACollectionStreamer*,
                             IDataStream&) const = 0;
#endif




















};

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeyBagAsHshTableOps : public IAKeyBagAsHshTableOps {

  typedef  IAKeyBagAsHshTableOps Inherited;

  typedef  IKeyBagAsHshTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeyBagAsHshTableNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeyBagAsHshTableOps
                            (INumber);

           IKeyBagAsHshTableOps
                            (INumber, void*);

           IKeyBagAsHshTableOps
                            (IKeyBagAsHshTableOps
                              <Element, _Key,
                               ElementOps, Implementation> const&);

          ~IKeyBagAsHshTableOps
                            ();

  void     Assign           (void*, void const*) const;

  IACollectionImpl*
           Clone            () const;

  void*    CreateNode       (void const*) const;

  void*    CreateNodes      (INumber, size_t&) const;

  void     DeleteNode       (void*) const;

  void     DeleteNodes      (void*) const;

  bool EqualKeys        (void const*, void const*,
                             IArgType) const;

  unsigned long
           HashKey          (void const*, unsigned long,
                             IArgType) const;

  void*    Key              (void const*) const;

           operator Implementation*
                            ();



















protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;

#if ! defined (__INO_STREAMING__)
  void*    CreateNodeWithStreamer
                            (IACollectionStreamer*, IDataStream&) const;
#endif












};

#pragma pack (pop)
#pragma enum (pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#include <iikbhsh.inl>





#ifndef IC_BUILD
#include <iikbhsh.c>
#else
#if ! defined (__TEMPINC__)
#include <iikbhsh.c>
#endif
#endif



#endif // _IIKBHSH_
