// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 59 1.6.1.4 source/core/collect/iiestab.h, collection, ioc.v400, 001006 
#ifndef _IIESTAB_
#define _IIESTAB_

#include <iiesseq.h>
#include <iiseqtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IEqualitySequenceOnSequenceImpl
         <ISequenceAsTableImpl> IEqualitySequenceAsTableImpl;

typedef IAEqualitySequenceOnSequenceOps
         <ISequenceAsTableImpl> IAEqualitySequenceAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IEqualitySequenceAsTableOps :
  public IAEqualitySequenceAsTableOps {

  typedef  IEqualitySequenceAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, ISequenceAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IEqualitySequenceAsTableOps
                           (INumber);

           IEqualitySequenceAsTableOps
                           (INumber, void*);

           IEqualitySequenceAsTableOps
                           (IEqualitySequenceAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IEqualitySequenceAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator ISequenceAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iiestab.c>
#endif



#pragma info (restore)


#endif // _IIESTAB_
