// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 42 1.5.1.4 source/core/collect/iicsm.c, collection, ioc.v400, 001006 
#ifndef _IICSM_C_
#define _IICSM_C_

#include <iiexc.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#ifdef IC_BUILD
#define __IOC_INLINE
#else
#define __IOC_INLINE inline
#endif

// ---
// ICSortedMapImpl
// ---

// public members

template <class CInherited>
__IOC_INLINE
ICSortedMapImpl <CInherited>::
ICSortedMapImpl (Ops& ops, INumber numberOfElements)
: CInherited (ops, numberOfElements)
{
}

template <class CInherited>
__IOC_INLINE
ICSortedMapImpl <CInherited>::
ICSortedMapImpl
  (Ops& ops, ICSortedMapImpl <CInherited> const& collection)
: CInherited (ops, collection)
{
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
Add (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor      (this->ClassName (), "Add")

  bool hasBeenAdded = CInherited::Add (element, cursor);
  if (! hasBeenAdded)
    ICHECK_Equality (this->ClassName (), "Add")
  return hasBeenAdded;
}

template <class CInherited>
__IOC_INLINE
void
ICSortedMapImpl <CInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ ICHECK_Identical (this->ClassName (), "AddAllFrom")

  CInherited::AddAllFrom (collection);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
AddOrReplaceElementWithKey (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (this->ClassName (), "AddOrReplaceElementWithKey")

  return CInherited::AddOrReplaceElementWithKey (element, cursor);
}

template <class CInherited>
__IOC_INLINE
void*
ICSortedMapImpl <CInherited>::
Any () const
{ ICHECK_IsEmpty (this->ClassName (), "Any")

  return CInherited::Any ();
}

template <class CInherited>
__IOC_INLINE
void*
ICSortedMapImpl <CInherited>::
ElementAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "ElementAt")
  ICHECK_IsValid      (this->ClassName (), "ElementAt")



#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "ElementAt")
#endif

  return CInherited::ElementAt (cursor);
}

template <class CInherited>
__IOC_INLINE
void*
ICSortedMapImpl <CInherited>::
ElementAtPosition (IPosition position) const
{ ICHECK_Position (this->ClassName (), "ElementAtPosition")

  return CInherited::ElementAtPosition (position);
}

template <class CInherited>
__IOC_INLINE
void*
ICSortedMapImpl <CInherited>::
ElementWithKey (void const* key) const
{ return CInherited::ElementWithKey (key);
}

template <class CInherited>
__IOC_INLINE
void*
ICSortedMapImpl <CInherited>::
First () const
{ ICHECK_IsEmpty (this->ClassName (), "First")

  return CInherited::First ();
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
IsFirstAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "IsFirstAt")
  ICHECK_IsValid      (this->ClassName (), "IsFirstAt")



#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "IsFirstAt")
#endif

  return CInherited::IsFirstAt (cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
IsLastAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "IsLastAt")
  ICHECK_IsValid      (this->ClassName (), "IsLastAt")



#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "IsLastAt")
#endif

  return CInherited::IsLastAt (cursor);
}

template <class CInherited>
__IOC_INLINE
void*
ICSortedMapImpl <CInherited>::
Last () const
{ ICHECK_IsEmpty (this->ClassName (), "Last")

  return CInherited::Last ();
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
Locate (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor (this->ClassName (), "Locate")

  return CInherited::Locate (element, cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
LocateElementWithKey (void const* key, ICursorImpl& cursor) const
{ ICHECK_IsFor (this->ClassName (), "LocateElementWithKey")

  return CInherited::LocateElementWithKey (key, cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
LocateNext (void const* element, ICursorImpl& cursor) const
{ ICHECK_IsFor   (this->ClassName (), "LocateNext")
  ICHECK_IsValid (this->ClassName (), "LocateNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (this->ClassName (), "LocateNext")
#endif

  return CInherited::LocateNext (element, cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
LocateNextElementWithKey (void const* key, ICursorImpl& cursor) const
{ ICHECK_IsFor   (this->ClassName (), "LocateNextElementWithKey")
  ICHECK_IsValid (this->ClassName (), "LocateNextElementWithKey")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (this->ClassName (), "LocateNextElementWithKey")
#endif

  return CInherited::LocateNextElementWithKey (key, cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
LocateOrAdd (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (this->ClassName (), "LocateOrAdd")

  return CInherited::LocateOrAdd (element, cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
LocateOrAddElementWithKey (void const* key, ICursorImpl& cursor)
{ ICHECK_IsFor (this->ClassName (), "LocateOrAddElementWithKey")

  return CInherited::LocateOrAddElementWithKey (key, cursor);
}

template <class CInherited>
__IOC_INLINE
IPosition
ICSortedMapImpl <CInherited>::
PositionAt (ICursorImpl const& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "PositionAt")
  ICHECK_IsValid      (this->ClassName (), "PositionAt")



#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "PositionAt")
#endif

  return CInherited::PositionAt (cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSortedMapImpl <CInherited>::
RemoveAt (ICursorImpl& cursor)
{ ICHECK_IsFor        (this->ClassName (), "RemoveAt")
  ICHECK_IsValid      (this->ClassName (), "RemoveAt")



#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "RemoveAt")
#endif

  CInherited::RemoveAt (cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSortedMapImpl <CInherited>::
RemoveAtPosition (IPosition position)
{ ICHECK_Position (this->ClassName (), "RemoveAtPosition")

  CInherited::RemoveAtPosition (position);
}

template <class CInherited>
__IOC_INLINE
void
ICSortedMapImpl <CInherited>::
RemoveFirst ()
{ ICHECK_IsEmpty (this->ClassName (), "RemoveFirst")

  CInherited::RemoveFirst ();
}

template <class CInherited>
__IOC_INLINE
void
ICSortedMapImpl <CInherited>::
RemoveLast ()
{ ICHECK_IsEmpty (this->ClassName (), "RemoveLast")

  CInherited::RemoveLast ();
}

template <class CInherited>
__IOC_INLINE
void
ICSortedMapImpl <CInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ ICHECK_IsFor        (this->ClassName (), "ReplaceAt")
  ICHECK_IsValid      (this->ClassName (), "ReplaceAt")



#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "ReplaceAt")
#endif
  ICHECK_Replacement  (this->ClassName (), "ReplaceAt")

  CInherited::ReplaceAt (cursor, element);
}

template <class CInherited>
__IOC_INLINE
void
ICSortedMapImpl <CInherited>::
ReplaceAtPosition (IPosition position, void const* element)
{ ICHECK_Position    (this->ClassName (), "ReplaceAtPosition")
  ICursorImpl& cursor = this->CursorOf (*this);
  this->SetToPosition (position, cursor);
  ICHECK_Replacement (this->ClassName (), "ReplaceAtPosition")

  CInherited::ReplaceAtPosition (position, element);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
ReplaceElementWithKey (void const* element, ICursorImpl& cursor)
{ ICHECK_IsFor (this->ClassName (), "ReplaceElementWithKey")

  return CInherited::ReplaceElementWithKey (element, cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
SetToFirst (ICursorImpl& cursor) const
{ ICHECK_IsFor (this->ClassName (), "SetToFirst")

  return CInherited::SetToFirst (cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
SetToLast (ICursorImpl& cursor) const
{ ICHECK_IsFor (this->ClassName (), "SetToLast")

  return CInherited::SetToLast (cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
SetToNext (ICursorImpl& cursor) const
{ ICHECK_IsFor   (this->ClassName (), "SetToNext")
  ICHECK_IsValid (this->ClassName (), "SetToNext")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (this->ClassName (), "SetToNext")
#endif

  return CInherited::SetToNext (cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
SetToNextWithDifferentKey (ICursorImpl& cursor) const
{ ICHECK_IsFor        (this->ClassName (), "SetToNextWithDifferentKey")
  ICHECK_IsValid      (this->ClassName (), "SetToNextWithDifferentKey")



#if defined (IALL_CHECKS)
  ICHECK_Cursor       (this->ClassName (), "SetToNextWithDifferentKey")
#endif

  return CInherited::SetToNextWithDifferentKey (cursor);
}

template <class CInherited>
__IOC_INLINE
void
ICSortedMapImpl <CInherited>::
SetToPosition (IPosition position, ICursorImpl& cursor) const
{ ICHECK_IsFor     (this->ClassName (), "SetToPosition")
  ICHECK_Position  (this->ClassName (), "SetToPosition")

  CInherited::SetToPosition (position, cursor);
}

template <class CInherited>
__IOC_INLINE
bool
ICSortedMapImpl <CInherited>::
SetToPrevious (ICursorImpl& cursor) const
{ ICHECK_IsFor   (this->ClassName (), "SetToPrevious")
  ICHECK_IsValid (this->ClassName (), "SetToPrevious")
#if defined (IALL_CHECKS)
  ICHECK_Cursor  (this->ClassName (), "SetToPrevious")
#endif

  return CInherited::SetToPrevious (cursor);
}


#pragma info (restore)


#endif // _IICSM_C_
