// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 15 1.6.1.4 source/core/collect/iibagtab.h, collection, ioc.v400, 001006 
#ifndef _IIBAGTAB_
#define _IIBAGTAB_

#include <iibagkb.h>
#include <iikbtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IBagOnKeyBagImpl
         <IKeyBagAsTableImpl> IBagAsTableImpl;

typedef IABagOnKeyBagOps
         <IKeyBagAsTableImpl> IABagAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IBagAsTableOps :
  public IABagAsTableOps {

  typedef  IABagAsTableOps Inherited;

  typedef  IBagAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeyBagAsTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeyBagAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IBagAsTableOps
                           (INumber);

           IBagAsTableOps
                           (INumber, void*);

           IBagAsTableOps
                           (IBagAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IBagAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeyBagAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iibagtab.c>
#endif



#pragma info (restore)


#endif // _IIBAGTAB_
