#ifndef _IHANDLE_INL_
#define _IHANDLE_INL_
/*----------------------------------------------------------------------------*/
/* FILE NAME: ihandle.inl                                                     */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   This file contains the definition of the inline functions for the        */
/*   classes declared in ihandle.hpp.                                         */
/*                                                                            */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Material - Property of IBM                                      */
/*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                  */
/*                                                                            */
/*----------------------------------------------------------------------------*/
// Revision: 54 1.10.2.1 source/ui/baseapp/ihandle.inl, datatype, ioc.v400, 001006 


/*------------------------------------------------------------------------------
| IWindowHandle::IWindowHandle                                                 |
------------------------------------------------------------------------------*/
#ifdef IC_MOTIFPM
inline IWindowHandle::IWindowHandle ( Value value )
  : fhandle( value )
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
inline IWindowHandle::IWindowHandle ( Value value )
  : fhandle( value )
  #else
inline IWindowHandle::IWindowHandle ( void* value )
  : fhandle( (Value) value )
  #endif
 #else
inline IWindowHandle::IWindowHandle ( Value value )
  : fhandle( value )
 #endif
#endif // IC_WIN
{
}

inline unsigned long IWindowHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IWindowHandle::operator Value ( ) const
{
  return this->fhandle;
}

inline ostream& operator << ( ostream &aStream, const IWindowHandle& handle )
{
  return aStream << handle.asString();
}


/*------------------------------------------------------------------------------
| IStringHandle::IStringHandle                                                 |
------------------------------------------------------------------------------*/
inline IStringHandle::IStringHandle ( Value value )
  : fhandle( value )
  {
  }

inline unsigned long IStringHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IStringHandle::operator Value ( ) const
{
  return this->fhandle;
}

inline ostream& operator << ( ostream &aStream, const IStringHandle& handle )
{
  return aStream << handle.asString();
}


/*------------------------------------------------------------------------------
| IProfileHandle::IProfileHandle                                               |
------------------------------------------------------------------------------*/
inline IProfileHandle::IProfileHandle ( Value value )
  : fhandle( value )
  {
  }

inline unsigned long IProfileHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IProfileHandle::operator Value ( ) const
{
  return this->fhandle;
}

inline ostream& operator << ( ostream &aStream, const IProfileHandle& handle )
{
  return aStream << handle.asString();
}

/*------------------------------------------------------------------------------
| IMessageQueueHandle::IMessageQueueHandle                                     |
------------------------------------------------------------------------------*/
inline IMessageQueueHandle::IMessageQueueHandle ( Value value )
  : fhandle( value )
  {
  }

inline unsigned long IMessageQueueHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IMessageQueueHandle::operator Value ( ) const
{
  return this->fhandle;
}

inline ostream& operator << ( ostream &aStream, const IMessageQueueHandle& handle )
{
  return aStream << handle.asString();
}

/*------------------------------------------------------------------------------
| IAccelTblHandle::IAccelTblHandle                                             |
------------------------------------------------------------------------------*/
#ifdef IC_MOTIFPM
inline IAccelTblHandle::IAccelTblHandle ( Value value )
  : fhandle( value )
#endif
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
inline IAccelTblHandle::IAccelTblHandle ( Value value )
  : fhandle( value )
  #else
inline IAccelTblHandle::IAccelTblHandle ( void* value )
  : fhandle( (Value) value )
  #endif
 #else
inline IAccelTblHandle::IAccelTblHandle ( Value value )
  : fhandle( value )
 #endif
#endif // IC_WIN
{
}

inline unsigned long IAccelTblHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IAccelTblHandle::operator Value ( ) const
{
  return this->fhandle;
}

inline ostream& operator << ( ostream &aStream, const IAccelTblHandle& handle )
{
  return aStream << handle.asString();
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IDisplayHandle::IDisplayHandle                                               |
------------------------------------------------------------------------------*/
inline IDisplayHandle::IDisplayHandle ( Value value )
  : fhandle(value )
  {
  }

inline unsigned long IDisplayHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IDisplayHandle::operator Value ( ) const
{
  return this->fhandle;
}

inline ostream& operator << ( ostream &aStream, const IDisplayHandle& handle )
{
  return aStream << handle.asString();
}


#endif

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IMenuHandle::IMenuHandle                                                     |
------------------------------------------------------------------------------*/
 #ifdef IC_WIN_STRICT
  #ifdef IC_WIN_STRICT_HANDLES
inline IMenuHandle::IMenuHandle ( Value value )
  : fhandle( value )
  #else
inline IMenuHandle::IMenuHandle ( void* value )
  : fhandle( (Value) value )
  #endif
 #else
inline IMenuHandle::IMenuHandle ( Value value )
  : fhandle( value )
 #endif
{
}

inline unsigned long IMenuHandle::asUnsigned ( ) const
{
  return (unsigned long) this->fhandle;
}

inline IMenuHandle::operator Value ( ) const
{
  return this->fhandle;
}

inline ostream& operator << ( ostream &aStream, const IMenuHandle& handle )
{
  return aStream << handle.asString();
}


#endif // IC_WIN
#endif // _IHANDLE_INL_
