// ----------------------------------------------------------------------------
//  FILE: igstream.hpp
//
//  This file declares the global streaming operators.
//
//  COPYRIGHT
//      IBM Open Class Library
//      (C) Copyright International Business Machines Corporation,  1997
//
//      Licensed Material - Program-Property of IBM - All Rights Reserved.
//
// Revision: 61 1.17.2.2 source/core/streams/igstream.hpp, oss, ioc.v400, 001006 
// ----------------------------------------------------------------------------

#ifndef _IGSTREAM_
#define _IGSTREAM_

#ifndef IC_BUILD
#define __IOC_INLINE inline
#else
#define __IOC_INLINE
#endif

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

//
// external class declarations.
//
class IDataStream;
class IMStreamable;

__IOC_INLINE void operator<<=(IMStreamable& c, IDataStream& s);
__IOC_INLINE void operator<<=(char& c, IDataStream& s);
__IOC_INLINE void operator<<=(signed char& c, IDataStream& s);
__IOC_INLINE void operator<<=(unsigned char& c, IDataStream& s);
__IOC_INLINE void operator<<=(short& c, IDataStream& s);
__IOC_INLINE void operator<<=(unsigned short& c, IDataStream& s);
__IOC_INLINE void operator<<=(long& c, IDataStream& s);
__IOC_INLINE void operator<<=(unsigned long& c, IDataStream& s);
__IOC_INLINE void operator<<=(float& c, IDataStream& s);
__IOC_INLINE void operator<<=(double& c, IDataStream& s);

__IOC_INLINE void operator>>=(const IMStreamable& object, IDataStream& s);
__IOC_INLINE void operator>>=(char c, IDataStream& s);
__IOC_INLINE void operator>>=(signed char c, IDataStream& s);
__IOC_INLINE void operator>>=(unsigned char c, IDataStream& s);
__IOC_INLINE void operator>>=(short c, IDataStream& s);
__IOC_INLINE void operator>>=(unsigned short c, IDataStream& s);
__IOC_INLINE void operator>>=(long c, IDataStream& s);
__IOC_INLINE void operator>>=(unsigned long c, IDataStream& s);
__IOC_INLINE void operator>>=(float c, IDataStream& s);
__IOC_INLINE void operator>>=(double c, IDataStream& s);

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <igstream.inl>

#endif
