// Revision: 28 1.7.1.15 source/ui/baseapp/ifont.hpp, font, ioc.v400, 001006 
#ifndef _IFONT_
#define _IFONT_
/*******************************************************************************
* FILE NAME: IFONT.HPP                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IFont                                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

// Forward declarations.
class IString;
class IWindow;
class IFontDialog;
class IPoint;
class ISize;
class IFontPrivateData;
class IBidiSettings;
class ITextStyleSet;

struct _FATTRS;
struct _FONTMETRICS;
struct HWND__;
struct tagLOGFONTA;

struct _XFontSet;
struct _XmFontListRec;

#ifdef IC_PM
extern "C"
{
   void* _System   _IFontDlgProc( unsigned long  hwnd,
                                  unsigned long  ulMsg,
                                  void*          mp1,
                                  void*          mp2 );
}
#endif // IC_PM
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
extern "C" {
   void* __stdcall _IFontDlgProc( struct HWND__* hwnd,
                                  unsigned long  ulMsg,
                                  void*          mp1,
                                  void*          mp2 );
 #else
extern "C" {
   void* __stdcall _IFontDlgProc( void*          hwnd,
                                  unsigned long  ulMsg,
                                  void*          mp1,
                                  void*          mp2 );
 #endif
}
#endif // IC_WIN

#pragma enum(4)
#pragma pack(push,4)

class IFont {
public:
/*------------------------------- Constructors -------------------------------*/
  IFont         (const IWindow* window = 0);

  IFont         (const char*    faceName,
                 unsigned long  pointSize = 0,
                 bool        useFixedFont = false,
                 bool        useVectorFont = false,
                 const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());

  IFont         (const IPresSpaceHandle& presSpaceHandle);

  IFont         (const IFont&            fntCopy);

#ifdef IC_MOTIF
  IFont         (_XmFontListRec*         fontList);
#endif

  IFont&        operator=(const IFont&   font);

virtual
 ~IFont         ( );

/*--------------------- Setting General Font Attributes ----------------------*/
virtual IFont
 &setName       (const char* name,
                 const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setPointSize  (unsigned long size,
                 const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());

/*------------------- Setting Font Style -------------------------------------*/
virtual IFont
#ifndef IC_MOTIF_FLAGNOP
 &setUnderscore     (bool underscore = true),
 &setStrikeout      (bool strikeout  = true),
#endif
#ifndef IC_MOTIFWIN_FLAGNOP
 &setOutline        (bool outline    = true),
#endif
 &setBold           (bool bold       = true),
 &setItalic         (bool italics    = true),
 &setAllEmphasis    (bool turnOn     = true);

/*------------------- Getting Font Style -------------------------------------*/
bool
#ifndef IC_MOTIF_FLAGNOP
  isUnderscore      ( ) const,
  isStrikeout       ( ) const,
#endif
#ifndef IC_MOTIFWIN_FLAGNOP
  isOutline         ( ) const,
#endif
  isBold            ( ) const,
  isItalic          ( ) const;

ITextStyleSet
  styleSet          ( ) const;

/*------------------------- Getting Font Attributes --------------------------*/
bool
  isBitmap          ( ) const,
  isFixed           ( ) const;

IString
  name              ( ) const;

IString
  qualifiedName     ( ) const;

unsigned long
  pointSize         ( ) const;

/*------------------------ Setting Font Direction ----------------------------*/
enum Direction {
  defaultDir,
  leftToRight,
  topToBottom,
  rightToLeft,
  bottomToTop
};

#ifndef IC_MOTIF_FLAGNOP
virtual IFont
 &setDirection      (Direction direction);
#endif

#ifdef IC_MOTIFPM
/*------------------------ Geometry Accessors---------------------------------*/
ISize
  superscriptSize   ( ) const,
  subscriptSize     ( ) const,
  superscriptOffset ( ) const,
  subscriptOffset   ( ) const;
#endif  // IC_MOTIFPM

ISize
  maxSize           ( ) const,
  maxUppercaseSize  ( ) const;

unsigned long
  charWidth         (char c) const,
  textWidth         (const char* text) const,
#ifdef IC_PMWIN
  textWidth         (const char* text, IBidiSettings& settings) const,
#endif
  minTextWidth      (const char* line) const,
  textLines         (const char* text,
                     unsigned long lineWidth) const,
  maxAscender       ( ) const,
  maxDescender      ( ) const,
#ifndef IC_MOTIF_FLAGNOP
  internalLeading   ( ) const,
  externalLeading   ( ) const,
#endif
  maxCharHeight     ( ) const,
  avgCharWidth      ( ) const;

#ifdef IC_MOTIFPM
unsigned long
  avgLowercase      ( ) const,
  avgUppercase      ( ) const,
  maxLowercaseAscender  ( ) const,
  maxLowercaseDescender ( ) const;
#endif

/*---------------------- Setting Window Font ---------------------------------*/
virtual bool
  setWindowFont    (IWindow* window) const;

#ifndef IC_MOTIF_FLAGNOP
/*--------------------- Setting Vector Font Attributes -----------------------*/
virtual IFont
 &setCharWidth   (unsigned long width,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setCharHeight  (unsigned long height,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setCharSize    (const ISize& size,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setFontAngle   (const IPoint& point,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setFontShear   (const IPoint& point,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());
#endif

/*--------------------- Drawing Functions ------------------------------------*/
virtual IFont
 &beginUsingFont     (const IPresSpaceHandle& presSpaceHandle),
 &endUsingFont       (const IPresSpaceHandle& presSpaceHandle);

/*-------------------------------- Font Types --------------------------------*/
virtual IFont
 &useNonPropOnly  (bool nonProportionalOnly = true,
                   const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &useBitmapOnly   (bool bitmapOnly = true,
                   const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &useVectorOnly   (bool vectorOnly = true,
                   const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());

bool
  isNonPropOnly    () const,
  isBitmapOnly     () const,
  isVectorOnly     () const;

/*---------- Accessing Presentation Manager Structures Related to Font -------*/
#ifdef IC_MOTIF
_XFontSet
 *fontSet     ();
_XmFontListRec
 *mFontList   ();
#endif

#ifdef IC_PM
const struct _FATTRS
 *fattrs      () const;
const struct _FONTMETRICS
 *fontmetrics () const;
#endif

#ifdef IC_WIN
const struct tagLOGFONTA
 *logfont     () const;
#endif

#ifdef IC_PMWIN
class FaceNameCursor {
public:
/*-------------------------------- Font Type ---------------------------------*/
enum FontType
{
  bitmap,
  vector,
  both
};

/*------------------------------- Constructors -------------------------------*/
  FaceNameCursor (FontType fontType = both,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());
virtual
 ~FaceNameCursor ( );

/*-------------------------------- Overrides ---------------------------------*/
virtual bool
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( ),
  isValid       ( ) const;

virtual void
  invalidate    ( );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned
  index,
  count;
IString
 *facenames;

friend class IFont;
};  //FaceNameCursor

class PointSizeCursor {
public:
/*------------------------------- Constructors -------------------------------*/
  PointSizeCursor(const char* facename,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());
virtual
 ~PointSizeCursor ( );

/*-------------------------------- Overrides ---------------------------------*/
virtual bool
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( ),
  isValid       ( ) const;

virtual void
  invalidate    ( );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned
  index,
  count;
long
 *pointsizes;

friend class IFont;
};  //PointSizeCursor

/*---------------------- Cursor Related Functions ----------------------------*/
static IString
  faceNameAt( const FaceNameCursor& faceNameCursor );

static long
  pointSizeAt( const PointSizeCursor& pointSizeCursor );
#endif //IC_PMWIN

private:
/*--------------------------------- Private ----------------------------------*/
IFontPrivateData
 *ppd;

#ifdef IC_PMWIN
IFont
 &initialize     (const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &copyPrivate( );

IFont
 &makeFontMetrics(const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle(),
                  bool fUpdateCharSet = true ),
 &fontChanged    (),
 &mustUseVector  (bool fDoIt = true),
 &setFontFromDialog (IFontDialog& fontDlg,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());
#endif

#ifdef IC_PM
friend  void* _System
  _IFontDlgProc( unsigned long hwnd,
                 unsigned long msg,
                 void*         mp1,
                 void*         mp2 );
#endif

#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
friend void* __stdcall
  _IFontDlgProc( struct HWND__* hwnd,
                 unsigned long  msg,
                 void*          mp1,
                 void*          mp2 );
 #else
friend void* __stdcall
  _IFontDlgProc( void*         hwnd,
                 unsigned long msg,
                 void*         mp1,
                 void*         mp2 );
 #endif
#endif // IC_WIN

#ifdef IC_PM
IFont
 &copyWidthsArray(char * buf, unsigned long length),
 &makeCharWidths (const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &checkForMatch  (const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setWidthHeight (unsigned long ulPointSize,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle()),
 &setSizeFromHps (unsigned long ulSize,
                  const IPresSpaceHandle& presSpaceHandle = IPresSpaceHandle());
#endif
#ifdef IC_MOTIF
IFont
 &setFontFromDialog( IFontPrivateData* fontData );
friend class IFontDialogSettingsData;
friend class IFontDialogData;
#endif
friend class IWindow;

}; //IFont

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _IFONT_
