// Revision: 71 1.11.1.7 source/ui/basectl/ientryfd.hpp, editctls, ioc.v400, 001006 
#ifndef _IENTRYFD_
  #define _IENTRYFD_
/*******************************************************************************
* FILE NAME: ientryfd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IEntryField                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IRange;
class ISize;
class IString;
class IResourceId;
class IColor;
class IEntryFieldData;

#pragma enum(4)
#pragma pack(push,4)

class IEntryField : public ITextControl {
typedef ITextControl
  Inherited;

public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IEntryField  ( unsigned long        id,
                 IWindow*             parent,
                 IWindow*             owner,
                 const IRectangle&    initial = IRectangle(),
                 const Style&         style = defaultStyle() );

  IEntryField  ( unsigned long        id,
                 IWindow*             parent );

  IEntryField  ( const IWindowHandle& handle );

virtual
 ~IEntryField  ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IEntryField, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU autoScroll,
  IC_IMPORTU margin,
  IC_IMPORTU readOnly,
  IC_IMPORTU unreadable,
  IC_IMPORTU leftAlign,
#ifndef IC_MOTIF_FLAGNOP
  IC_IMPORTU centerAlign,
  IC_IMPORTU rightAlign,
#endif
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU autoTab,
  IC_IMPORTU command,
  IC_IMPORTU sbcsData,
  IC_IMPORTU dbcsData,
  IC_IMPORTU mixedData,
#endif
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU border3D,
#endif
  IC_IMPORTU anyData;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*---------------------------- Enumerations ----------------------------------*/
enum Alignment {
  left,
  center,
  right
};

enum CharType {
  any,
  sbcs
#ifndef IC_WIN_FLAGNOP
  , dbcs,
  mixed
#endif
};

/*-------------------------------- Attributes --------------------------------*/
Alignment
  alignment          ( ) const;

CharType
  charType           ( ) const;

#ifndef IC_WIN_FLAGNOP
virtual IEntryField
 &enableCommand      ( bool   enable=true ),
 &disableCommand     ( ),
 &enableAutoTab      ( bool   enable=true ),
 &disableAutoTab     ( ),
 &enableMargin       ( bool   enable=true ),
 &disableMargin      ( ),
 &enableAutoScroll   ( bool   enable=true ),
 &disableAutoScroll  ( ),
 &setAlignment       ( Alignment alignment ),
 &setCharType        ( CharType  type );
#endif

bool
  isCommand          ( ) const,
  isAutoTab          ( ) const,
  isAutoScroll       ( ) const,
  isMargin           ( ) const;

/*-------------------------------- Clipboard Operations ----------------------*/
virtual IEntryField
 &cut        ( unsigned long timestamp=0 ),
 &copy       ( unsigned long timestamp=0 ),
 &paste      ( ),
 &clear      ( unsigned long timestamp=0 ),
 &discard    ( ),
 &removeAll  ( );

/*------------------------- Overloaded Disable/Enable Window -----------------*/
virtual IEntryField
 &disable  ( ),
 &enable   ( bool enable=true );

/*-------------------------------- Insert Mode -------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IEntryField
 &enableInsertMode   ( bool insert=true ),
 &disableInsertMode  ( );
#endif

bool
  isInsertMode       ( ) const;

/*---------------------------- Read-Only Operations --------------------------*/
virtual IEntryField
 &enableDataUpdate   ( bool update=true ),
 &disableDataUpdate  ( );

bool
  isWriteable        ( ) const;

/*-------------------------------- Text Limit --------------------------------*/
virtual IEntryField
 &setLimit  ( unsigned long      textLimit ),
 &setLimit  ( const IResourceId& textLimit );

virtual unsigned long
  limit     ( ) const;

/*-------------------------------- Selected Text -----------------------------*/
static const long IC_IMPORTU end;

virtual IEntryField
 &selectRange    ( const IRange& range = IRange(0,end),
                   unsigned long timestamp = 0 );

IRange
  selectedRange ( ) const;

IString
  selectedText  ( ) const;

unsigned long
  selectedTextLength ( ) const;

virtual IEntryField
 &setCursorPosition( unsigned long newCursorPos );

unsigned long
  cursorPosition ( ) const;

#ifdef IC_WIN
static void
  enableTextSelection ( bool selection = false );
static bool
  isTextSelectionEnabled ( );
#endif

/*-------------------------------- Left Index --------------------------------*/
virtual IEntryField
  &setLeftIndex ( unsigned long index );

#ifndef IC_WIN_FLAGNOP
unsigned long
  leftIndex    ( ) const;
#endif

/*-------------------------------- Test Operations ---------------------------*/
bool
  hasTextChanged  ( ) const,
  isEmpty         ( ) const,
  hasSelectedText ( ) const;

virtual IEntryField
 &setTextChangedFlag    ( bool changed=true ),
 &resetTextChangedFlag  ( );

#ifdef IC_PMWIN
/*---------------------------------- Colors ----------------------------------*/
virtual IColor
  foregroundColor ( ) const,
  backgroundColor ( ) const;
#endif

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU insertModeId,
#endif
  IC_IMPORTU dataUpdateId,
  IC_IMPORTU limitId,
  IC_IMPORTU characterTypeId;

/*----------------------- Observer Notification ------------------------------*/
virtual IEntryField
 &enableNotification ( bool enable=true );

/*-------------------------------- Text Operations ---------------------------*/
#ifdef IC_WIN
virtual IEntryField
 &setText            ( const char* text ),
 &setText            ( const IResourceId& text );
#endif  // IC_WIN

#ifdef IC_MOTIF
virtual IString
  text               ( ) const;
#endif  // IC_MOTIF

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

#ifdef IC_MOTIF
/*---------------------- Event-Handling Implementation -----------------------*/
IEntryField
 &initialize ( unsigned long style, const IWindowHandle& wh );
#endif //IC_MOTIF

#ifdef IC_MOTIFWIN
virtual bool
  passEventToOwner( IEvent& event );
#endif  //IC_MOTIFWIN

#ifdef IC_MOTIF
/*-------------------------------- Overrides ---------------------------------*/
virtual IEntryField
 &setLayoutDistorted     ( unsigned long layoutAttributeOn,
                           unsigned long layoutAttributeOff );
#endif

#ifdef IC_PMWIN
/*---------------------------------- Styles ----------------------------------*/
virtual IEntryField
 &setStyle ( unsigned long style );
#endif

/*------------------------------- Constructors -------------------------------*/
  IEntryField ( );

/*-------------------------- Drag and Drop Support ---------------------------*/
#ifdef IC_WIN
virtual bool
  isDragStarting( IEvent &event );
#endif


private:
/*------------------------------ Hidden Members ------------------------------*/
  IEntryField  ( const IEntryField& entryField );
IEntryField
 &operator=    ( const IEntryField& entryField );

/*--------------------------------- Private ----------------------------------*/
friend class IEntryFieldNotifyHandler;
friend class IEntryHandler;

IRange
  getCursorInfo ( ) const;

void
  setCursorInfo ( const IRange &range );

static Style
  currentDefaultStyle;

#ifdef IC_WIN
static bool
  fgTextSelection ;
#endif

enum ReadStatus {
  doesntMatter,
  wasInput,
  wasRead,
  wasInputButReset,
  wasReadButReset
};

ReadStatus
  eReadStatus;

bool
  queryInsMode;

IEntryFieldData
 *fEntryFieldData;

/*------------------------------ Obsolete Members ----------------------------*/
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
public:
bool
  hasChanged      ( ) const;

virtual IEntryField
  &setChangedFlag ( bool changeFlag = true );
#endif

/*----------------------- Obsolete Data and Functions ------------------------*/
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
public:
#ifdef IC_WIN
static const Style
  IC_IMPORTU upperCase,
  IC_IMPORTU lowerCase;
#endif
#endif // IC_OBSOLETE

}; // IEntryField

INESTEDBITFLAGCLASSFUNCS(Style, IEntryField)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _IENTRYFD_ */
