// Revision: 52 1.13.1.15 source/ui/basectl/icombobs.hpp, listctls, ioc.v400, 001006 
#ifndef _ICOMBOBS_
  #define _ICOMBOBS_
/*******************************************************************************
* FILE NAME: icombobs.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBaseComboBox                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ientryfd.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IBaseComboBoxData;
class IBaseComboBoxCursorData;
class IBaseComboHandler;

#pragma enum(4)
#pragma pack(push,4)

class IBaseComboBox : public IEntryField {
typedef IEntryField
  Inherited;

public:
class Style;
class Cursor;
/*------------------------------- Constructors -------------------------------*/
  IBaseComboBox       ( unsigned long     id,
                        IWindow*          parent,
                        IWindow*          owner,
                        const IRectangle& initial = IRectangle  ( ),
                        const Style&      style   = defaultStyle( ) );

#ifdef IC_PMWIN
  IBaseComboBox       ( unsigned long     id,
                        IWindow*          parent );

  IBaseComboBox       ( const IWindowHandle& handle );
#endif

virtual
  ~IBaseComboBox      ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IBaseComboBox, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU simpleType,
  IC_IMPORTU dropDownType,
  IC_IMPORTU readOnlyDropDownType,
  IC_IMPORTU horizontalScroll;
#ifdef IC_PMWIN
static const Style
  IC_IMPORTU autoScroll;
#endif
#ifndef IC_MOTIF_FLAGNOP
  #ifdef IC_MOTIFPM
static const Style
   IC_IMPORTU  anyData,
   IC_IMPORTU  sbcsData,
   IC_IMPORTU  dbcsData,
   IC_IMPORTU  mixedData;
  #endif
  #ifdef IC_WIN
static const Style
   IC_IMPORTU  oemData;
  #endif
#endif
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle        ( );

static void
  setDefaultStyle     ( const Style&    style );

virtual unsigned long
  convertToGUIStyle   ( const IBitFlag& style,
                        bool         extendedOnly = false ) const;

bool
  isHorizontalScroll  ( ) const;

/*------------------------- Type Members -------------------------------------*/
enum ControlType {
  simple,
  dropDown,
  dropDownList,
  readOnlyDropDown = dropDownList
};

ControlType
  type                ( ) const;

/*-------------------------------- Text Limit --------------------------------*/
#ifdef IC_WIN
virtual IBaseComboBox
 &setLimit  ( unsigned long      textLimit ),
 &setLimit  ( const IResourceId& textLimit );

virtual unsigned long
  limit     ( ) const;
#endif

/*------------------------- List Box Operations ------------------------------*/
bool
  isListShowing       ( ) const;

virtual IBaseComboBox
  &showList           ( bool show=true ),
  &hideList           ( );

/*------------------------- Get and Change Items -----------------------------*/
virtual IString
  itemText            ( unsigned long      index ) const;

virtual IBaseComboBox
 &setItemText         ( unsigned long      index,
                        const char*        string,
                        bool            updateEntryField = false ),
 &setItemText         ( unsigned long      index,
                        const IResourceId& string,
                        bool            updateEntryField = false );

virtual IString
  elementAt           ( const Cursor& cursor ) const;

/*------------------------- Selection ----------------------------------------*/
virtual IBaseComboBox
  &select             ( unsigned long index,
                        bool       select = true ),
  &deselect           ( unsigned long index ),
  &deselectAll        ( );

virtual bool
  isSelected          ( unsigned long index ) const;

virtual unsigned long
  numberOfSelections  ( ) const;

virtual long
  selection           ( ) const;

/*------------------------- Scrolling Members --------------------------------*/
virtual IBaseComboBox&
  setTop              ( unsigned long index );

virtual unsigned long
  top                 ( ) const;

/*------------------------- Attributes ---------------------------------------*/
virtual bool
  hasFocus            ( ) const;
#ifdef IC_MOTIF
virtual IBaseComboBox
 &setFocus                  ( );
#endif

/*--------------------- Read-Only Operation Overrides ------------------------*/
#ifdef IC_WIN
virtual IBaseComboBox
 &enableDataUpdate   ( bool update=true );

bool
  isWriteable        ( ) const;
#endif

/*------------------------- Handle Members -----------------------------------*/
virtual IBaseComboBox&
  setItemHandle       ( unsigned long index,
                        unsigned long handle );

virtual unsigned long
  itemHandle          ( unsigned long index ) const;

/*------------------------- Search List --------------------------------------*/
static const unsigned long
  IC_IMPORTU notFound,
  IC_IMPORTU first;

enum SearchType {
  prefix,
  substring,
  exactMatch
};

virtual unsigned long
  locateText           ( const char*   searchString,
                         bool       caseSensitive = true,
                         SearchType    search        = exactMatch,
                         unsigned long index         = first ) const;

/*------------------------- Content ------------------------------------------*/
virtual unsigned long
  count                ( ) const;

virtual bool
  isEmpty              ( ) const;


/*------------------------- Color --------------------------------------------*/
#ifdef IC_MOTIF
virtual IBaseComboBox
  &setForegroundColor  ( const IColor &color ),
  &setBackgroundColor  ( const IColor &color );

virtual IColor
  foregroundColor              ( ) const,
  backgroundColor              ( ) const;
#endif

/*------------------------- Window Positioning -------------------------------*/
#ifdef IC_MOTIF
virtual IPoint
  position             ( ) const;

virtual ISize
  size                 ( ) const;

virtual IRectangle
  rect                 ( ) const;

virtual IWindow&
  moveSizeTo           ( const IRectangle& newSizeAndPosition );
#endif  //IC_MOTIF

#ifdef IC_MOTIFWIN
virtual IRectangle
  nativeRect           ( ) const;
#endif  // IC_MOTIFWIN

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  IC_IMPORTU enterId,
  IC_IMPORTU selectId,
  IC_IMPORTU itemChangedId,
  IC_IMPORTU itemsId;


virtual IBaseComboBox
  &enableNotification  ( bool enable = true );

/*------------------------- Layout Support -----------------------------------*/
virtual IRectangle
  layoutAdjustment     ( ) const,
  visibleRectangle     ( ) const;

virtual IBaseComboBox
  &setMinimumRows      ( unsigned long minimumRows );

unsigned long
  minimumRows          ( ) const;

class Cursor  {

public:
/*---------------------- Filters --------------------------------*/
enum Filter {
  selectedItems,
  allItems
};

/*------------------------------- Constructors -------------------------------*/
  Cursor               ( const IBaseComboBox& comboBox,
                         Filter               type = selectedItems );
virtual
  ~Cursor              ( );

/*---------------------- Cursor Movement ------------------------*/
virtual bool
  setToFirst           ( ),
  setToNext            ( ),
  setToPrevious        ( ),
  setToLast            ( ),
  setToIndex           ( unsigned long index );

/*---------------------- Cursor Validation and Conversion -------*/
virtual bool
  isValid              ( ) const;

virtual void
  invalidate           ( );

virtual unsigned long
  asIndex              ( ) const;


private:
/*------------------------------ Hidden Members ------------------------------*/
Cursor                 ( const Cursor& cursor );
Cursor
 &operator=            ( const Cursor& cursor );

/*--------------------------------- Private ----------------------------------*/
const IBaseComboBox
 &rlbCl;
unsigned long
  lClCurrent;
Filter
  cursorTypeCl;
unsigned long
  sameValidation;

IBaseComboBoxCursorData
 *fCursorData;
};


protected:
/*---------------------------- Layout Support --------------------------------*/
virtual ISize
  calcMinimumSize      ( ) const;

#ifdef IC_MOTIF
virtual IBaseComboBox
 &setLayoutDistorted   ( unsigned long layoutAttributeOn,
                         unsigned long layoutAttributeOff );
#endif

/*------------------------------ Item Changes --------------------------------*/
unsigned long
  changeCount          ( ) const;

void
  incrementChangeCount ( );

/*------------------------------- Color --------------------------------------*/
#ifdef IC_MOTIF
virtual IBaseComboBox
 &setColor         ( unsigned long colorArea,
                     const IColor& color );
#endif

private:
/*------------------------------ Hidden Members ------------------------------*/
IBaseComboBox          ( const IBaseComboBox& comboBox );
IBaseComboBox
 &operator=            ( const IBaseComboBox& comboBox );

/*--------------------------------- Private ----------------------------------*/
friend class IBaseComboBox::Cursor;
friend class IBaseComboBoxData;
friend class IBaseComboHandler;
#ifdef IC_PM
friend class IBaseShowListHandler;
friend class IBaseResizeHandler;
#endif
#ifdef IC_MOTIF
friend class IComboBox;
friend class IListResizeHandler;
friend class IWindow;
#endif

#ifdef IC_WIN
friend class IBaseComboHandler;
 #ifdef IC_WIN_STRICT
friend long  __stdcall
   icomboboxEntryWinProc( struct HWND__* hwnd,
                          unsigned int   msg,
                          unsigned int   mp1,
                          long           mp2 );
 #else
friend long  __stdcall
   icomboboxEntryWinProc(void*         hwnd,
                         unsigned int  msg,
                         unsigned int  mp1,
                         long          mp2);
 #endif
#endif // IC_WIN
#ifdef IC_PM
friend void* _System
   icomboboxEntryWinProc(unsigned long hwnd,
                         unsigned long msg,
                         void*         mp1,
                         void*         mp2);
#endif


#ifdef IC_PMWIN
IEntryField::Alignment
  alignment            ( ) const;
virtual IBaseComboBox
 &setAlignment         ( IEntryField::Alignment alignment );
#endif

static Style
  currentDefaultStyle;

unsigned long
  needValidation;

IBaseComboBoxData
 *fBaseComboBoxData;
};  /* IBaseComboBox */

INESTEDBITFLAGCLASSFUNCS(Style, IBaseComboBox)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _ICOMBOBS_ */
