// Revision: 81 1.5.2.1 source/core/base/ibhandle.inl, appsupport, ioc.v400, 001006 
#ifndef _IBHANDLE_INL_
#define _IBHANDLE_INL_ 0
/*----------------------------------------------------------------------------*/
/* FILE NAME: ibhandle.inl                                                    */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   This file contains the definition of the inline functions for the        */
/*   classes declared in ibhandle.hpp.                                        */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   5645-001                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1997                                 */
/*                                                                            */
/*----------------------------------------------------------------------------*/

#include <istream.hpp>


// ----------------------------------------------------------------------------
//  IHandle
// ----------------------------------------------------------------------------
inline IHandle::IHandle(Value value) :

    handle( value )
{
}

inline unsigned long IHandle::asUnsigned() const
{
    return (unsigned long)this->handle;
}

inline ostream& operator<<(ostream& aStream, const IHandle& aHandle )
{
    return aStream << aHandle.asString();
}

inline IHandle::operator IHandle::Value() const
{
    return this->handle;
}


// ----------------------------------------------------------------------------
//  IProcessId
// ----------------------------------------------------------------------------
inline IProcessId::IProcessId (Value value) :

    handle( value )
{
}

inline unsigned long IProcessId::asUnsigned() const
{
    return ((unsigned long)this->handle);
}

inline IProcessId::operator IProcessId::Value() const
{
    return this->handle;
}

inline IThreadId::IThreadId ()
{
    fSystemThreadId = 0;
}

inline ostream& operator<<(ostream& aStream, const IProcessId& aHandle)
{
    return aStream << aHandle.asString();
}


// ----------------------------------------------------------------------------
//  IThreadId
// ----------------------------------------------------------------------------
// #ifdef IC_POSIX

// inline IThreadId::IThreadId  (const pthread_t&  thid)
// {
//     fSystemThreadId  = &priv_thid;
//     *fSystemThreadId = thid;
// }

// #endif // IC_POSIX

// #ifdef IC_PMWIN
inline IThreadId::IThreadId  (unsigned long  thid)
{
    this->fSystemThreadId = thid;
}
// #endif


inline IThreadId::~IThreadId ( )
{
#ifdef IC_POSIX
       fSystemThreadId = 0;
#endif
}

inline IThreadId::IThreadId (const IThreadId  &tid )
{
// #ifdef IC_POSIX

//     fSystemThreadId = 0;

//     if (tid.isValid() )
//     {
//         fSystemThreadId = &priv_thid;
//         *fSystemThreadId = tid;
//     }
// #endif // IC_POSIX

// #ifdef IC_PMWIN
    fSystemThreadId = tid;
// #endif // IC_PMWIN
}


inline ostream& operator<<(ostream& aStream, const IThreadId& aHandle)
{
    return aStream << aHandle.asString();
}


// ----------------------------------------------------------------------------
//  IThreadHandle
// ----------------------------------------------------------------------------




















// ----------------------------------------------------------------------------
//  IEnumHandle
// ----------------------------------------------------------------------------
inline IEnumHandle::IEnumHandle(Value value) :

    handle( value )
{
}

inline unsigned long IEnumHandle::asUnsigned() const
{
    return ( (unsigned long)this->handle );
}

inline IEnumHandle::operator IEnumHandle::Value() const
{
    return this->handle;
}

inline ostream& operator<<(ostream& aStream, const IEnumHandle& aHandle)
{
    return aStream << aHandle.asString();
}


// ----------------------------------------------------------------------------
//  IPrivateSemaphoreHandle
// ----------------------------------------------------------------------------
inline IPrivateSemaphoreHandle::IPrivateSemaphoreHandle(Value privSemId)
{
    fSystemPrivSemId = privSemId;
}

inline IPrivateSemaphoreHandle::~IPrivateSemaphoreHandle()
{
#ifdef IC_POSIX
    if (fSystemPrivSemId != 0)
    {
        fSystemPrivSemId  = 0;
    }
#endif
}

inline IPrivateSemaphoreHandle::operator IPrivateSemaphoreHandle::Value ( ) const
{
    return this->fSystemPrivSemId;
}


inline ostream& operator<<(ostream& aStream, const IPrivateSemaphoreHandle& aHandle)
{
    return aStream << aHandle.asString();
}


// ----------------------------------------------------------------------------
//  ISharedSemaphoreHandle
// ----------------------------------------------------------------------------
inline ISharedSemaphoreHandle::ISharedSemaphoreHandle(Value value) :

    handle(value)
{
}

inline unsigned long ISharedSemaphoreHandle::asUnsigned() const
{
    return((unsigned long)this->handle);
}

inline ISharedSemaphoreHandle::operator ISharedSemaphoreHandle::Value() const
{
    return this->handle;
}

inline ostream& operator<<(ostream& aStream, const ISharedSemaphoreHandle& aHandle)
{
    return aStream << aHandle.asString();
}


// ----------------------------------------------------------------------------
//  IAnchorBlockHandle
// ----------------------------------------------------------------------------
inline IAnchorBlockHandle::IAnchorBlockHandle(Value value) :

    fhandle( value )
{
}

inline unsigned long IAnchorBlockHandle::asUnsigned ( ) const
{
    return (unsigned long) this->fhandle;
}

inline IAnchorBlockHandle::operator IAnchorBlockHandle::Value() const
{
    return this->fhandle;
}

inline ostream& operator<<(ostream& aStream, const IAnchorBlockHandle& handle)
{
    return aStream << handle.asString();
}


// ----------------------------------------------------------------------------
//  IModuleHandle
// ----------------------------------------------------------------------------

inline IModuleHandle::IModuleHandle ( Value value )

  : fhandle( value )















{
}

inline unsigned long IModuleHandle::asUnsigned() const
{
    return (unsigned long) this->fhandle;
}

inline IModuleHandle::operator IModuleHandle::Value() const
{
    return this->fhandle;
}

inline ostream& operator<<(ostream& aStream, const IModuleHandle& handle)
{
    return aStream << handle.asString();
}

#endif // _IBHANDLE_INL_
