//----------------------------------------------------------------------------
// FILE NAME: ibhandle.hpp
//
// DESCRIPTION:
//   Declaration of the classes:
//     IAnchorBlockHandle
//     IHandle
//     ISemaphoreHandle
//     IThreadId
//     IModuleHandle
//     IProcessId
//     IThreadHandle
//     IEnumHandle
//     IPrivateSemaphoreHandle
//     ISharedSemaphoreHandle
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997
//
// Revision: 80  1.7.1.9  source/core/base/ibhandle.hpp, appsupport, ioc.v400, 001006  
// ----------------------------------------------------------------------------

#ifndef _IBHANDLE_
#define _IBHANDLE_

#include <ibase.hpp>
#include <istring.hpp>

extern "C"
{
#ifdef IC_POSIX

    // define feature test macros


















    #include <unistd.h>
    #include <errno.h>
#endif

#ifdef ASC_DEBUG
    #include <stdio.h>
#endif
}

#include <ievtdata.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ostream;
class IString;
struct HINSTANCE__;
struct _XtAppStruct;

#ifndef IC_BUILD
class IHandle;
class IThreadId;
class IProcessId;
class IEnumHandle;
class IPrivateSemaphoreHandle;
class ISharedSemaphoreHandle;
class IModuleHandle;
class IAnchorBlockHandle;
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const IHandle& aHandle);
inline ostream IC_EXPORTB &operator<< (ostream& aStream, const IThreadId& aHandle);
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const IProcessId& aHandle);
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const IEnumHandle& aHandle);
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const IPrivateSemaphoreHandle& aHandle);
inline ostream IC_EXPORTB &operator<<(ostream& aStream, const ISharedSemaphoreHandle& aHandle);
inline ostream &operator<<(ostream& aStream, const IModuleHandle& aHandle);
inline ostream &operator<<(ostream& aStream, const IAnchorBlockHandle& aHandle);
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTB IHandle
{
public:
    // ---------------------------------- Value -------------------------------



    typedef unsigned long Value;


    // ------------------------------- Constructors ---------------------------
    IHandle (Value value);

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const IHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

protected:
    // ---------------------------------- Value -------------------------------
    Value handle;
};


class IC_EXPORTB IThreadId
{
public:
    // ------------------------------- Constructors ---------------------------
    IThreadId();
    IThreadId(const IThreadId& tid );
    IThreadId& operator= ( const IThreadId& tid );

    IThreadId(unsigned long thid);

    // ------------------------------- Destructors ----------------------------
    ~IThreadId();


    // -------------------------------- Operators -----------------------------
    friend bool IC_EXPORTB operator==(  const IThreadId  &threadId1,
                                        const IThreadId  &threadId2);

    friend bool IC_EXPORTB operator!=(  const IThreadId  &threadId1,
                                        const IThreadId  &threadId2);

    bool isValid() const;


    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB &
        operator<< (ostream& aStream, const IThreadId& aHandle );

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator unsigned long() const;

private:
    unsigned long   fSystemThreadId;
};































typedef IThreadId IThreadHandle;



class IC_EXPORTB IProcessId
{
public:



    typedef unsigned long Value;


    // ------------------------------- Constructors ---------------------------
    IProcessId(Value pid = 0);

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const IProcessId& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value handle;

};


class IC_EXPORTB IEnumHandle
{
public:



    typedef unsigned long Value;


    // ------------------------------- Constructors ---------------------------
    IEnumHandle(Value henum = 0);

    // ------------------------------- Diagnostics ----------------------------
    IString asString () const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const IEnumHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value handle;
};


class IC_EXPORTB IPrivateSemaphoreHandle
{
public:


  typedef  unsigned long  Value;




    // ------------------------------- Constructors ---------------------------
    IPrivateSemaphoreHandle(Value privSemId = 0);

#ifdef IC_POSIX
//     IPrivateSemaphoreHandle& operator=(pthread_mutex_t* privSemId);
    IPrivateSemaphoreHandle& operator=(Value privSemId);
#endif

    // ------------------------------- Destructors ----------------------------
    ~IPrivateSemaphoreHandle();

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const IPrivateSemaphoreHandle& aHandle);

// #ifdef IC_PMWIN
    unsigned long asUnsigned() const;
// #endif

    // -------------------------------- Operators -----------------------------
    operator Value() const;


private:
    // ---------------------------------- Value -------------------------------
    Value fSystemPrivSemId;
};


class IC_EXPORTB ISharedSemaphoreHandle
{
public:



    typedef unsigned long  Value;


    // ------------------------------- Constructors ---------------------------
    ISharedSemaphoreHandle(Value hsem = 0);

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream IC_EXPORTB
        &operator<<(ostream& aStream, const ISharedSemaphoreHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value handle;
};

typedef ISharedSemaphoreHandle ISemaphoreHandle;

class IModuleHandle
{
public:
    // ---------------------------------- Value -------------------------------





    typedef unsigned long Value;











    // ------------------------------- Constructors ---------------------------

    IModuleHandle(Value value = 0);













    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream
        &operator<<(ostream& aStream, const IModuleHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value fhandle;
};

class IAnchorBlockHandle
{
public:
    // ---------------------------------- Value -------------------------------





    typedef unsigned long Value;






    // ------------------------------- Constructors ---------------------------
    IAnchorBlockHandle(Value value = 0);

    // ------------------------------- Diagnostics ----------------------------
    IString asString() const;
    IString asDebugInfo() const;

    friend ostream
        &operator<<(ostream& aStream, const IAnchorBlockHandle& aHandle);

    unsigned long asUnsigned() const;

    // -------------------------------- Operators -----------------------------
    operator Value() const;

private:
    // ---------------------------------- Value -------------------------------
    Value fhandle;
};


#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <ibhandle.inl>

#endif // _IBHANDLE_
