// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 91 1.4.1.4 source/core/collect/iatree.inl, collection, ioc.v400, 001006 
#ifndef _IATREE_INL_
#define _IATREE_INL_

#include <ilanglvl.hpp>

#ifndef IC_BUILD
#define __IOC_INLINE inline
#else
#define __IOC_INLINE
#endif


// --------------------
// ITreeCollectionGuard
// --------------------

// public members

template <class Element>
inline
ITreeCollectionGuard<Element>::
ITreeCollectionGuard (IATree<Element>& c, long timeout)
: ivCollection(c)
{ c.ImplOf(c).Seize(timeout);
}

template <class Element>
inline
ITreeCollectionGuard<Element>::
~ITreeCollectionGuard ()
{ ivCollection.ImplOf(ivCollection).Release();
}


// ------------------
// IElementTreeCursor
// ------------------

// public members

template <class Element>
inline Element const&
IElementTreeCursor <Element>::
element () const
{ return *(Element const*) ImplOf (*this).Element ();
}

// protected members

template <class Element>
inline
IElementTreeCursor <Element>::
IElementTreeCursor (Implementation* impl)
: ITreeCursor (impl)
{
}

// ------
// IATree
// ------

// public members

template <class Element>
inline
IATree <Element>::
~IATree ()
{
}

template <class Element>
inline void
IATree <Element>::
addAsChild (ITreeCursor const& cursor,
            IPosition position, Element const& element)
{ ImplOf (*this).AddAsChild (CrsrImplOf (cursor), position, &element);
}

template <class Element>
inline void
IATree <Element>::
addAsRoot (Element const& element)
{ ImplOf (*this).AddAsRoot (&element);
}

template <class Element>
inline bool
IATree <Element>::
allElementsDo (bool (*applFunc) (Element&, void*),
               ITreeIterationOrder order, void* addArg)
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)applFunc, order, addArg);
}

template <class Element>
inline bool
IATree <Element>::
allElementsDo (bool (*applFunc) (Element const&, void*),
               ITreeIterationOrder order, void* addArg) const
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)applFunc, order, addArg);
}

template <class Element>
inline bool
IATree <Element>::
allElementsDo (IApplicator <Element>& applicator,
               ITreeIterationOrder order)
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)__applFunc, order, &applicator);
}

template <class Element>
inline bool
IATree <Element>::
allElementsDo (IConstantApplicator <Element>& applicator,
               ITreeIterationOrder order) const
{ return ImplOf (*this).
    AllElementsDo ((IApplFunc)__applFunc, order, &applicator);
}

template <class Element>
inline bool
IATree <Element>::
allSubtreeElementsDo
  (ITreeCursor const& cursor,
   bool (*applFunc) (Element&, void*),
   ITreeIterationOrder order, void* addArg)
{ return ImplOf (*this).AllSubtreeElementsDo
    (CrsrImplOf (cursor), (IApplFunc)applFunc, order, addArg);
}

template <class Element>
inline bool
IATree <Element>::
allSubtreeElementsDo
  (ITreeCursor const& cursor,
   bool (*applFunc) (Element const&, void*),
   ITreeIterationOrder order, void* addArg) const
{ return ImplOf (*this).AllSubtreeElementsDo
    (CrsrImplOf (cursor), (IApplFunc)applFunc, order, addArg);
}

template <class Element>
inline bool
IATree <Element>::
allSubtreeElementsDo (ITreeCursor const& cursor,
                      IApplicator <Element>& applicator,
                      ITreeIterationOrder order)
{ return ImplOf (*this).AllSubtreeElementsDo
    (CrsrImplOf (cursor), (IApplFunc)__applFunc, order, &applicator);
}

template <class Element>
inline bool
IATree <Element>::
allSubtreeElementsDo (ITreeCursor const& cursor,
                      IConstantApplicator <Element>& applicator,
                      ITreeIterationOrder order) const
{ return ImplOf (*this).AllSubtreeElementsDo
    (CrsrImplOf (cursor), (IApplFunc)__applFunc, order, &applicator);
}

template <class Element>
inline IPosition
IATree <Element>::
childPositionAt (ITreeCursor const& cursor) const
{ return ImplOf (*this).ChildPositionAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element&
IATree <Element>::
elementAt (ITreeCursor const& cursor)
{ return *(Element*) ImplOf (*this).ElementAt (CrsrImplOf (cursor));
}

template <class Element>
inline Element const&
IATree <Element>::
elementAt (ITreeCursor const& cursor) const
{ return *(Element const*) ImplOf (*this).
    ElementAt (CrsrImplOf (cursor));
}

template <class Element>
inline bool
IATree <Element>::
isConsistent () const
{ return ImplOf (*this).IsConsistent ();
}

template <class Element>
inline bool
IATree <Element>::
isEmpty () const
{ return ImplOf (*this).IsEmpty ();
}

template <class Element>
inline bool
IATree <Element>::
isLeaf (ITreeCursor const& cursor) const
{ return ImplOf (*this).IsLeaf (CrsrImplOf (cursor));
}

template <class Element>
inline bool
IATree <Element>::
isRoot (ITreeCursor const& cursor) const
{ return ImplOf (*this).IsRoot (CrsrImplOf (cursor));
}

template <class Element>
inline ITreeCursor*
IATree <Element>::
newCursor () const
{ return InterfaceFor (ImplOf (*this).CreateCursor ());
}

template <class Element>
inline INumber
IATree <Element>::
numberOfElements () const
{ return ImplOf (*this).NumberOfElements ();
}

template <class Element>
inline INumber
IATree <Element>::
numberOfLeaves () const
{ return ImplOf (*this).NumberOfLeaves ();
}

template <class Element>
inline INumber
IATree <Element>::
numberOfSubtreeElements (ITreeCursor const& cursor) const
{ return ImplOf (*this).NumberOfSubtreeElements (CrsrImplOf (cursor));
}

template <class Element>
inline INumber
IATree <Element>::
numberOfSubtreeLeaves (ITreeCursor const& cursor) const
{ return ImplOf (*this).NumberOfSubtreeLeaves (CrsrImplOf (cursor));
}

template <class Element>
inline IPosition
IATree <Element>::
position (ITreeCursor const& cursor) const
{ return ImplOf (*this).ChildPositionAt (CrsrImplOf (cursor));
}

template <class Element>
inline INumber
IATree <Element>::
removeAll ()
{ return ImplOf (*this).RemoveAll ();
}

template <class Element>
inline INumber
IATree <Element>::
removeSubtree (ITreeCursor& cursor)
{ return ImplOf (*this).RemoveSubtree (CrsrImplOf (cursor));
}

template <class Element>
inline void
IATree <Element>::
replaceAt (ITreeCursor const& cursor, Element const& element)
{ ImplOf (*this).ReplaceAt (CrsrImplOf (cursor), &element);
}

template <class Element>
inline bool
IATree <Element>::
setToChild (IPosition position, ITreeCursor& cursor) const
{ return ImplOf (*this).SetToChild (position, CrsrImplOf (cursor));
}

template <class Element>
inline bool
IATree <Element>::
setToFirst (ITreeCursor& cursor, ITreeIterationOrder order) const
{ return ImplOf (*this).SetToFirst (CrsrImplOf (cursor), order);
}

template <class Element>
inline bool
IATree <Element>::
setToFirstExistingChild (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToFirstExistingChild (CrsrImplOf (cursor));
}

template <class Element>
inline bool
IATree <Element>::
setToLast (ITreeCursor& cursor, ITreeIterationOrder order) const
{ return ImplOf (*this).SetToLast (CrsrImplOf (cursor), order);
}

template <class Element>
inline bool
IATree <Element>::
setToLastExistingChild (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToLastExistingChild (CrsrImplOf (cursor));
}

template <class Element>
inline bool
IATree <Element>::
setToNext (ITreeCursor& cursor, ITreeIterationOrder order) const
{ return ImplOf (*this).SetToNext (CrsrImplOf (cursor), order);
}

template <class Element>
inline bool
IATree <Element>::
setToNextExistingChild (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToNextExistingChild (CrsrImplOf (cursor));
}

template <class Element>
inline bool
IATree <Element>::
setToParent (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToParent (CrsrImplOf (cursor));
}

template <class Element>
inline bool
IATree <Element>::
setToPrevious (ITreeCursor& cursor, ITreeIterationOrder order) const
{ return ImplOf (*this).SetToPrevious (CrsrImplOf (cursor), order);
}

template <class Element>
inline bool
IATree <Element>::
setToPreviousExistingChild (ITreeCursor& cursor) const
{ return ImplOf (*this).
    SetToPreviousExistingChild (CrsrImplOf (cursor));
}

template <class Element>
inline bool
IATree <Element>::
setToRoot (ITreeCursor& cursor) const
{ return ImplOf (*this).SetToRoot (CrsrImplOf (cursor));
}

#if ! defined (__INO_STREAMING__)
template <class Element>
inline
void
IATree <Element>::
operator<<= (IDataStream& stream)
{ ImplOf (*this).StreamIn (stream);
}

template <class Element>
__IOC_INLINE
void
IATree <Element>::
operator>>= (IDataStream& stream)
{ ImplOf (*this).StreamOut (stream);
}

template <class Element>
inline void
IATree <Element>::
adoptStreamer (IACollectionStreamer *streamer)
{ ImplOf (*this).AdoptStreamer(streamer);
}
#endif

// protected members

template <class Element>
inline
IATree <Element>::
IATree ()
: IATreeBase ()
{
}

template <class Element>
inline
IATree <Element>::
IATree (IATree <Element> const& tree)
: IATreeBase (tree)
{
}

template <class Element>
inline TYPENAME IATree <Element>::Implementation&
IATree <Element>::
ImplOf (IATree <Element> const& tree)
{ return *(Implementation*)tree.ivImpl;
}

#endif // _IATREE_INL_
