// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 65 1.6.1.5 source/core/collect/iarstrct.h, collection, ioc.v400, 001006 
#ifndef _IARSTRCT_
#define _IARSTRCT_

#include <ibcllct.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)


template <class Element>
class IRestrictedAccessCollectionGuard
{
public:
  IRestrictedAccessCollectionGuard
      (IARestrictedAccessCollection<Element>&, long timeout=-1);

  ~IRestrictedAccessCollectionGuard ();

private:

  IARestrictedAccessCollection<Element>& ivCollection;

  IRestrictedAccessCollectionGuard
      (const IRestrictedAccessCollectionGuard<Element>&);

  IRestrictedAccessCollectionGuard<Element>
      &operator= (const IRestrictedAccessCollectionGuard<Element>&);












};


template <class Element>
class IARestrictedAccessCollection : protected IACollectionBase {

  typedef  IACollectionImpl Implementation;

public:


           IARestrictedAccessCollection
                            (INotifier&);


  virtual ~IARestrictedAccessCollection
                            ();




  bool add              (Element const&);




  bool add              (Element const&, ICursor&);




  void     addAllFrom       (IARestrictedAccessCollection
                              <Element> const&);

  bool allElementsDo    (bool (*applicatorFunction)
                              (Element const&, void*),
                             void* additionalArgument = 0) const;

  bool allElementsDo    (IConstantApplicator <Element>&) const;

  Element const&
           any              () const;




  void     copy             (IARestrictedAccessCollection
                              <Element> const&);


  INotifier&
           disableNotification
                            ();


  Element const&
           elementAt        (ICursor const&) const;

  Element const&
           elementAtPosition
                            (IPosition) const;


  INotifier&
           enableNotification
                            (bool = true);


  Element const&
           first            () const;

  bool isBounded        () const;

  bool isConsistent     () const;

  bool isEmpty          () const;


  bool isEnabledForNotification
                            () const;


  bool isFirstAt        (ICursor const&) const;

  bool isFull           () const;

  bool isLastAt         (ICursor const&) const;

  Element const&
           last             () const;

  INumber  maxNumberOfElements
                            () const;




  ICursor* newCursor        () const;






  INotifier&
           notifier
                            ();

  INotifier const&
           notifier
                            () const;

  INotifier&
           notifyObservers  (INotificationEvent const&);


  INumber  numberOfElements () const;

  IPosition
           positionAt       (ICursor const&) const;




  INumber  removeAll        ();

  bool setToFirst       (ICursor&) const;

  bool setToLast        (ICursor&) const;

  bool setToNext        (ICursor&) const;

  void     setToPosition    (IPosition, ICursor&) const;

  bool setToPrevious    (ICursor&) const;


           operator INotifier&
                            () const;


  // for backward compatibility
  Element const&
           anyElement       () const;

  Element const&
           firstElement     () const;

  bool isFirst          (ICursor const&) const;

  bool isLast           (ICursor const&) const;

  Element const&
           lastElement      () const;

  IPosition
           position         (ICursor const&) const;

protected:


                friend class IRestrictedAccessCollectionGuard<Element>;


           IARestrictedAccessCollection
                            ();

           IARestrictedAccessCollection
                            (IARestrictedAccessCollection
                              <Element> const&);

  static
  Implementation&
           ImplOf           (IARestrictedAccessCollection
                              <Element> const&);

private:

#if ! defined (__INO_STREAMING__)
public:



  void   operator<<=      (IDataStream&);




  void   operator>>=      (IDataStream&);

  void   adoptStreamer    (IACollectionStreamer*);
#endif













};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iarstrct.inl>


#pragma info (restore)


#endif // _IARSTRCT_
