#ifndef __fastsem_h
   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(none)
      #endif
      #pragma info(restore)
   #endif

   #define __fastsem_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifndef _LNK_CONV
      #if __IBMC__ || __IBMCPP__ || defined(_OPTLINK_SUPPORTED)
         #define _LNK_CONV _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <fastsem.h> Header File                                         */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #if __WINDOWS__
      typedef union {
         void *handle;
         int index;
         } event_t;
   #elif __OS2__
      typedef unsigned long event_t;
   #endif

   enum {
      SEM_OK,
      SEM_ERROR,
      SEM_TIMEOUT,
      SEM_INTERUPT
      };
   #define SEM_INFINITE 0xffffffff

   #define SEM_SHARED 1

   typedef struct sem {
      int count;
      unsigned long acquiredBit;
      event_t event_sem;
      int flags;
      unsigned int opencount;
   } sem_t;

   int _LNK_CONV _IMPORT _SemCreate(sem_t*, int);
   int _LNK_CONV _IMPORT _SemSharedCreate(sem_t*, int);
   int _LNK_CONV _IMPORT _SemOpen(sem_t *sem);
   int _LNK_CONV _IMPORT _SemRequest(sem_t*, unsigned long);
   int _LNK_CONV _IMPORT _SemRelease(sem_t*);
   int _LNK_CONV _IMPORT _SemClose(sem_t *);

   #ifdef __cplusplus
      }
   #endif

   #if __IBMC__ || __IBMCPP__
      #pragma info(none)
      #ifndef __CHKHDR__
         #pragma info(restore)
      #endif
      #pragma info(restore)
   #endif
#endif
