#if !defined __builtin_h && (__IBMC__ || __IBMCPP__)
   #pragma info(none)
   #ifndef __CHKHDR__
      #pragma info(none)
   #endif
   #pragma info(restore)

   #define __builtin_h

   #if __cplusplus
      extern "C" {
   #endif

   /********************************************************************/
   /*  <builtin.h> Header File                                         */
   /*  IBM C and C++ Compilers for OS/2, AIX and for Windows NT,       */
   /*  Version 3.6                                                     */
   /*  Licensed Material - Property of IBM                             */
   /*  (C) Copyright IBM Corp. 1991, 1997. All rights reserved         */
   /*                                                                  */
   /********************************************************************/

   #ifndef __size_t
      #define __size_t
      typedef unsigned int size_t;
   #endif

   void *_Builtin __alloca(size_t);
   #if !defined _alloca
      #define _alloca(x) __alloca(x)
      #define alloca(x) __alloca(x)
   #endif

   #if __THW_PPC__
      void _Builtin __iospace_eieio();
      void _Builtin __iospace_sync();
      unsigned _Builtin short __load2r(unsigned short*);
      int _Builtin __load4r(unsigned int*);
      unsigned _Builtin short __store2r(unsigned short*);
      int _Builtin __store4r(unsigned int*);
      double _Builtin __readflm();
      double _Builtin __setflm(double);
      double _Builtin __setrnd(int);
   #elif __THW_INTEL__
      void           _Builtin __interrupt(const unsigned int);
      unsigned long  _Builtin __getTIBvalue(const unsigned int);

      double _Builtin __fsin(double);
      double _Builtin __fcos(double);
      double _Builtin __fptan(double);
      double _Builtin __fpatan(double);
      double _Builtin __facos(double);
      double _Builtin __fasin(double);
      double _Builtin __fsincos(double, double *);
      double _Builtin __fsqrt(double);
      double _Builtin __fcossin(double, double *);
      double _Builtin __f2xm1(double);
      double _Builtin __fyl2x(double, double);
      double _Builtin __fyl2xp1(double, double);

      void           _Builtin __enable(void);
      void           _Builtin __disable(void);
      int            _Builtin __inpb(const unsigned int);
      unsigned short _Builtin __inpw(const unsigned int);
      unsigned long  _Builtin __inpd(const unsigned int);
      int            _Builtin __outpb(const unsigned int, const int);
      unsigned short _Builtin __outpw(const unsigned int, const unsigned short);
      unsigned long  _Builtin __outpd(const unsigned int, const unsigned long);
      unsigned int   _Builtin __clear87(void);
      unsigned int   _Builtin __control87(unsigned int, unsigned int);
      unsigned int   _Builtin __status87(void);

      #if __OS2__
         unsigned char _Builtin __parmdwords(void);
      #endif

      #if _LONG_LONG
         unsigned long long _Builtin  __llrotl(unsigned long long, int);
         unsigned long long _Builtin  __llrotr(unsigned long long, int);
      #endif
      unsigned long  _Builtin __lrotl(unsigned long, int);
      unsigned long  _Builtin __lrotr(unsigned long, int);
      unsigned short _Builtin __srotl(unsigned short, int);
      unsigned short _Builtin __srotr(unsigned short, int);
      unsigned char  _Builtin __crotl(unsigned char, int);
      unsigned char  _Builtin __crotr(unsigned char, int);

      typedef struct _cpuidinfotag {
         unsigned int eax;
         unsigned int ebx;
         unsigned int ecx;
         unsigned int edx;
         } _cpuidinfo;

      enum {
         _cf   = 0x00000001,
         _pf   = 0x00000004,
         _af   = 0x00000010,
         _zf   = 0x00000040,
         _sf   = 0x00000080,
         _tf   = 0x00000100,
         _if   = 0x00000200,
         _df   = 0x00000400,
         _of   = 0x00000800,
         _iopl = 0x00003000,
         _nt   = 0x00004000,
         _res4 = 0x00008000,
         _rf   = 0x00010000,
         _vm   = 0x00020000,
         _ac   = 0x00040000,
         _vif  = 0x00080000,
         _vip  = 0x00100000,
         _id   = 0x00200000
         };

      #define FPU_FLAG   0x0001
      #define VME_FLAG   0x0002
      #define DE_FLAG    0x0004
      #define PSE_FLAG   0x0008
      #define TSC_FLAG   0x0010
      #define MSR_FLAG   0x0020
      #define PAE_FLAG   0x0040
      #define MCE_FLAG   0x0080
      #define CX8_FLAG   0x0100
      #define APIC_FLAG  0x0200
      #define SEP_FLAG   0x0800
      #define MTRR_FLAG  0x1000
      #define PGE_FLAG   0x2000
      #define MCA_FLAG   0x4000
      #define CMOV_FLAG  0x8000
      #define MMX_FLAG   0x800000

      int   _Builtin __lxchg(volatile int *, int);
      short _Builtin __sxchg(volatile short *, short);
      char  _Builtin __cxchg(volatile char *, char);

      #if __IBMC__ >= 360 || __IBMCPP__ >= 360
         void _Builtin __setCPUFlags(unsigned int);
         unsigned int _Builtin __getCPUFlags(void);
         _cpuidinfo *_Builtin __cpuid(unsigned int, _cpuidinfo*);
         void _Builtin __fence(void);
         int _Builtin __inc4(int*);
         int _Builtin __smp_inc4(int*);
         int _Builtin __dec4(int*);
         int _Builtin __smp_dec4(int*);
         unsigned short _Builtin __reverse2(unsigned short);
         unsigned int _Builtin __reverse4(unsigned int);
         unsigned long long _Builtin __reverse8(unsigned long long);
         unsigned int _Builtin __bts(unsigned int*, unsigned int);
         unsigned int _Builtin __smp_bts(unsigned int*, unsigned int);
         unsigned int _Builtin __btr(unsigned int*, unsigned int);
         unsigned int _Builtin __smp_btr(unsigned int*, unsigned int);
         unsigned int _Builtin __cmpxchg4(unsigned int*, unsigned int, unsigned int);
         unsigned int _Builtin __smp_cmpxchg4(unsigned int*, unsigned int, unsigned int);
         unsigned long long _Builtin __cmpxchg8(unsigned long long*, unsigned long long, unsigned long long);
         unsigned long long _Builtin __smp_cmpxchg8(unsigned long long*, unsigned long long, unsigned long long);
         unsigned int _Builtin __xadd4(unsigned int*, unsigned int);
         unsigned int _Builtin __smp_xadd4(unsigned int*, unsigned int);
         unsigned long long _Builtin __rdtsc(void);
         unsigned int _Builtin __cntlz4(unsigned int);
         unsigned int _Builtin __cntlz8(unsigned long long);
         unsigned int _Builtin __cnttz4(unsigned int);
         unsigned int _Builtin __cnttz8(unsigned long long);
      #endif

      #define _fsin(x)       __fsin(x)
      #define _fcos(x)       __fcos(x)
      #define _fptan(x)      __fptan(x)
      #define _fpatan(x)     __fpatan(x)
      #define _facos(x)      __facos(x)
      #define _fasin(x)      __fasin(x)
      #define _fsincos(x, y) __fsincos(x, y)
      #define _fsqrt(x)      __fsqrt(x)
      #define _fcossin(x, y) __fcossin(x, y)
      #define _f2xm1(x)      __f2xm1(x)
      #define _fyl2x(x, y)   __fyl2x(x, y)
      #define _fyl2xp1(x, y) __fyl2xp1(x, y)

      #define _interrupt(x)   __interrupt(x)
      #define _getTIBvalue(x) __getTIBvalue(x)
      #define _enable()       __enable()
      #define _disable()      __disable()
      #define _inp(x)         __inpb(x)
      #define _inpw(x)        __inpw(x)
      #define _inpd(x)        __inpd(x)
      #define _outp(x, y)     __outpb(x, y)
      #define _outpw(x, y)    __outpw(x, y)
      #define _outpd(x, y)    __outpd(x, y)

      #if _LONG_LONG
         #define _llrotl(x, y) __llrotl(x, y)
         #define _llrotr(x, y) __llrotr(x, y)
      #endif
      #define _rotl(x, y)  __lrotl(x, y)
      #define _rotr(x, y)  __lrotr(x, y)
      #define _lrotl(x, y) __lrotl(x, y)
      #define _lrotr(x, y) __lrotr(x, y)
      #define _srotl(x, y) __srotl(x, y)
      #define _srotr(x, y) __srotr(x, y)
      #define _crotl(x, y) __crotl(x, y)
      #define _crotr(x, y) __crotr(x, y)
   #endif

   #if __cplusplus
      }
   #endif

   #pragma info(none)
   #ifndef __CHKHDR__
      #pragma info(restore)
   #endif
   #pragma info(restore)
#endif

