#------------------------------------------------------------------
# abtwsi make file for Win32 (VA C++; version 3.5)
#------------------------------------------------------------------
#
TARGETOS = BOTH
!include <win32.mak>
#
# Add the element $(MEMDEBUG) to the COPTS to enable memory debugging
MEMDEBUG = /Tm /DMEM_DEBUG
#
#  Add /Ti for debug mode; use /O for optimization
COPTS = /C /Mc /W3 /q /Sm /Ss /Gm+ /Gd- /DOPSYS_WIN32 /O
#
#  Use /Debug for debugging
LOPTS = /PM:VIO /NOLOGO
#
ALL: abtwsc.dll abtwstt.dll abtwsac.exe abtwsai.dll abtwsan.dll abtwsam.dll
#
#------------------------------------------------------------------
# Core Functions DLL
#------------------------------------------------------------------

obj/abtwsc.obj: ..\source\abtwsc.c \
   {..\source\;$(INCLUDE);}abtwscos.h \
   {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj\abtwsc.obj ..\source\abtwsc.c

obj/abtwscos.obj: ..\source\abtwscos.c \
    {..\source\;$(INCLUDE);}abtwscos.h \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj\abtwscos.obj ..\source\abtwscos.c

obj/abtwsc.exp: abtwsc.def
    ilib.exe /Gi:obj/abtwsc abtwsc.def

abtwsc.dll: obj/abtwsc.obj obj/abtwscos.obj obj/abtwsc.exp
    ilink.exe @<<
     $(LOPTS) /DLL
     obj/abtwsc.exp
     obj/abtwscos.obj
     obj/abtwsc.obj
<<

#------------------------------------------------------------------
# Base TCP/IP Transport Functions DLL
#------------------------------------------------------------------

obj/abtwstt.obj: ..\source\abtwstt.c \
    {..\source\;$(INCLUDE);}abtwstbs.h \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj/abtwstt.obj ..\source\abtwstt.c

obj/abtwstbs.obj: ..\source\abtwstbs.c \
    {..\source\;$(INCLUDE);}abtwstbs.h \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj/abtwstbs.obj ..\source\abtwstbs.c

obj/abtwstt.exp: abtwstt.def
    ilib.exe /Gi:obj/abtwstt abtwstt.def

abtwstt.dll: obj/abtwstt.obj obj/abtwstbs.obj obj/abtwstt.exp obj/abtwsc.lib
    ilink.exe @<<
     $(LOPTS) /DLL
     obj/abtwstt.exp
     obj/abtwstt.obj
     obj/abtwstbs.obj
     obj/abtwsc.lib
     wsock32.lib
<<

#------------------------------------------------------------------
# CGI Executable
#------------------------------------------------------------------

obj/abtwsac.obj: ..\source\abtwsac.c \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Foobj\abtwsac.obj ..\source\abtwsac.c

abtwsac.exe: obj/abtwsac.obj obj/abtwsc.lib
    ilink.exe @<<
      $(LOPTS)
      obj/abtwsac.obj
      obj/abtwsc.lib
      wsock32.lib
<<

#------------------------------------------------------------------
# IBM ICS Adapter DLL
#------------------------------------------------------------------

obj/abtwsai.obj: ..\source\abtwsai.c \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj\abtwsai.obj ..\source\abtwsai.c

obj/abtwsai.exp: abtwsai.def
    ilib.exe /Gi:obj/abtwsai abtwsai.def

abtwsai.dll: obj/abtwsai.obj obj/abtwsai.exp obj/abtwsc.lib
    ilink.exe @<<
     $(LOPTS) /DLL
     obj/abtwsai.exp
     obj/abtwsai.obj
     obj/abtwsc.lib
     httpdapi.lib
<<

#------------------------------------------------------------------
# Netscape NSAPI Adapter DLL
#------------------------------------------------------------------

obj/abtwsan.obj: ..\source\abtwsan.c \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /DXP_WIN32 /Foobj\abtwsan.obj ..\source\abtwsan.c

obj/abtwsan.exp: abtwsan.def
    ilib.exe /Gi:obj/abtwsan abtwsan.def

abtwsan.dll: obj/abtwsan.obj obj/abtwsan.exp obj/abtwsc.lib
    ilink.exe @<<
     $(LOPTS) /DLL
     obj/abtwsan.exp
     obj/abtwsan.obj
     obj/abtwsc.lib
     libhttpd.lib
<<

#------------------------------------------------------------------
# Microsoft ISAPI Adapter DLL
#------------------------------------------------------------------

obj/abtwsam.obj: ..\source\abtwsam.c \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj\abtwsam.obj ..\source\abtwsam.c

obj/abtwsam.exp: abtwsam.def
    ilib.exe /Gi:obj/abtwsam abtwsam.def

abtwsam.dll: obj/abtwsam.obj obj/abtwsam.exp obj/abtwsc.lib
    ilink.exe @<<
     $(LOPTS) /DLL /NOD /NOE
     obj/abtwsam.exp
     obj/abtwsam.obj
     obj/abtwsc.lib
     CPPWM35.LIB
     $(baselibs)
<<

#------------------------------------------------------------------
