#------------------------------------------------------------------
# abtwsi make file for HP UX 
#------------------------------------------------------------------
#
CC = cc
LD = ld
#
# CFLAGS:		C compiler flags
#
#	-Ae		Enable extended ANSI extensions
#	-c		Compile only
#	-O		Level 2 optimization
#	+z		Compile PIC
#
CFLAGS    =  -Ae -O +z -DHP720 -D_HPUX_SOURCE -DOPSYS_HPUX
SL_CFLAGS = $(CFLAGS) -c
#
# LFLAGS:		Linker flags
#
#	-b		Create shared library
#	+b.		Shared library default location
# 	+s		Search SHLIB_PATH at runtime
#       -E              Mark all symbols for export to shared libraries
#
LFLAGS = -b -o $@ +b. +s -E
#
LIBS = -L.:/usr/lib -lc
#
NETSCAPE_INCLUDES = -I/usr/ns-home/nsapi/include -I/usr/ns-home/nsapi/include/base -I/usr/ns-home/nsapi/include/frame
ICS_INCLUDES = -I/opt/IBMICS/internet/samples/API
#
ALL: abtwsc.sl abtwstt.sl abtwsac abtwsai.sl abtwsan.sl abtwstn.sl
#
#------------------------------------------------------------------
# Core Functions Shared Object
#------------------------------------------------------------------

obj/abtwsc.o: ../source/abtwsc.c \
	../source/abtwscos.h \
	../source/abtwsi.h
	$(CC) $(SL_CFLAGS) ../source/abtwsc.c -o obj/abtwsc.o

obj/abtwscos.o: ../source/abtwscos.c \
	../source/abtwscos.h \
	../source/abtwsi.h
	$(CC) $(SL_CFLAGS) ../source/abtwscos.c -o obj/abtwscos.o
    
abtwsc.sl: obj/abtwsc.o obj/abtwscos.o
	$(LD) $(LFLAGS) -h Config -o $@ obj/abtwscos.o obj/abtwsc.o $(LIBS) -ldld

#------------------------------------------------------------------
# Base TCP/IP Transport Functions Shared Object
#------------------------------------------------------------------

obj/abtwstt.o: ../source/abtwstt.c \
	../source/abtwstbs.h \
	../source/abtwsi.h
	$(CC) $(SL_CFLAGS) -D_REENTRANT ../source/abtwstt.c -o obj/abtwstt.o
    
obj/abtwstbs.o: ../source/abtwstbs.c \
	../source/abtwstbs.h \
	../source/abtwsi.h
	$(CC) $(SL_CFLAGS) ../source/abtwstbs.c -o obj/abtwstbs.o
    
abtwstt.sl: obj/abtwstt.o obj/abtwstbs.o 
	$(LD) $(LFLAGS) -h Config -o $@ obj/abtwstt.o obj/abtwstbs.o $(LIBS) -lM abtwsc.sl
	  
#------------------------------------------------------------------
# CGI Executable
#------------------------------------------------------------------

abtwsac: ../source/abtwsac.c ../source/abtwsi.h
	$(CC) $(CFLAGS) ../source/abtwsac.c -o $@ $(LIBS) abtwsc.sl

#------------------------------------------------------------------
# IBM ICS Adapter Shared Object
#------------------------------------------------------------------

obj/abtwsai.o: ../source/abtwsai.c \
	../source/abtwsi.h
	$(CC) $(SL_CFLAGS) $(ICS_INCLUDES) ../source/abtwsai.c -o obj/abtwsai.o
    
abtwsai.sl: obj/abtwsai.o
	$(LD) $(LFLAGS)	-o $@ obj/abtwsai.o $(LIBS) abtwsc.sl 
	
#------------------------------------------------------------------
# Netscape NSAPI Adapter Shared Object
#------------------------------------------------------------------

obj/abtwsan.o: ../source/abtwsan.c \
	../source/abtwsi.h
	$(CC) $(SL_CFLAGS) $(NETSCAPE_INCLUDES) -DNETSSL -DHPUX DMCC_HTTPD -DXP_UNIX ../source/abtwsan.c -o obj/abtwsan.o

abtwsan.sl: obj/abtwsan.o 
	$(LD) $(LFLAGS) -o $@ obj/abtwsan.o $(LIBS) abtwsc.sl

#------------------------------------------------------------------
# Netscape TCP/IP Transport Functions Shared Object
#------------------------------------------------------------------

obj/abtwstn.o: ../source/abtwstt.c \
	../source/abtwstbs.h \
	../source/abtwsi.h
	$(CC) $(SL_CFLAGS) -D_REENTRANT $(NETSCAPE_INCLUDES) -DNETSSL -DHPUX DMCC_HTTPD -DXP_UNIX ../source/abtwstt.c -o obj/abtwstn.o
    
abtwstn.sl: obj/abtwstn.o obj/abtwstbs.o 
	$(LD) $(LFLAGS) -h Config -o $@ obj/abtwstn.o obj/abtwstbs.o $(LIBS) -lM abtwsc.sl
	  
#------------------------------------------------------------------