       CBL PGMNAME(MIXED) LIB
      *****************************************************************
      *    SMALLTALK CALLIN SAMPLE PROGRAM  (COBOL)                   *
      *****************************************************************
       IDENTIFICATION DIVISION.
       PROGRAM-ID. "COBSAMP".
       ENVIRONMENT DIVISION.
       DATA DIVISION.

       WORKING-STORAGE SECTION.

      *****************************************************************
      *    REQUIRED SMALLTALK VM CALLIN COPYBOOK                      *
      *****************************************************************
       COPY ABTXSCOB.
      *
       01 BUFFERLENGTH  PIC S9(9) BINARY VALUE 50.
       01 BUFFER.
          02 PARAM1  PIC X(15).
          02 PARAM2  PIC X(15).
          02 PARAM3  PIC X(15) VALUE "12/05/1976".
      *
       PROCEDURE DIVISION.
      *****************************************************************
      *    INITIALIZE REQUIRED SMALLTALK VM CALLIN PARAMETERS         *
      *****************************************************************
           MOVE "CALLINXX.ICX" TO IMAGENAME.
           MOVE "TestCallinApp" TO RECEIVER.
           MOVE "run" TO SELECTOR
      *****************************************************************
      *    SMALLTALK VM STARTUP                                       *
      *****************************************************************
           CALL "vastart" USING BY REFERENCE IMAGENAME
                                BY REFERENCE VHANDLE
                                BY REFERENCE VSTATUS.
           DISPLAY "".
           DISPLAY ">  VASTART() -> Smalltalk VM startup executed".
           DISPLAY ">     VHANDLE = " VHANDLE.
           IF VSTATUS NOT EQUAL TO ZERO
              PERFORM ERROR-ROUTINE THRU END-ERROR-ROUTINE.
      *****************************************************************
      *    SMALLTALK VM RUN IMAGE                                     *
      *****************************************************************
           CALL "varun" USING BY REFERENCE VHANDLE
                              BY REFERENCE RECEIVER
                              BY REFERENCE SELECTOR
                              BY CONTENT   BUFFERLENGTH
                              BY REFERENCE BUFFER
                              BY REFERENCE VSTATUS
                              BY REFERENCE VRESULT.
           DISPLAY "".
           DISPLAY ">  VARUN() -> Smalltalk VM run image executed".
           DISPLAY ">     VRESULT = " VRESULT.
           DISPLAY ">  The following data was returned by the callee".
           DISPLAY ">     IOArea [param1] = " PARAM1.
           DISPLAY ">     IOArea [param2] = " PARAM2.
           DISPLAY ">     IOArea [param3] = " PARAM3.
           
           IF VSTATUS NOT EQUAL TO ZERO
              PERFORM ERROR-ROUTINE THRU END-ERROR-ROUTINE.
      *****************************************************************
      *    SMALLTALK VM STOP                                          *
      *****************************************************************
           CALL "vastop" USING BY REFERENCE VHANDLE
                               BY REFERENCE VSTATUS.
           DISPLAY "".
           DISPLAY ">  VASTOP() -> Smalltalk VM stop executed".
           IF VSTATUS NOT EQUAL TO ZERO
              PERFORM ERROR-ROUTINE THRU END-ERROR-ROUTINE.
      *
           COMPUTE RETURN-CODE = 0.
           GOBACK.
      *
       ERROR-ROUTINE.
           DISPLAY "Error - VSTATUS = " VSTATUS.
           COMPUTE RETURN-CODE = VSTATUS.
           GOBACK.
       END-ERROR-ROUTINE.
      *
       END PROGRAM "COBSAMP".
