 /********************************************************************/
 /*  Smalltalk Callin Sample Program  (C)                            */
 /********************************************************************/

#ifdef ABT_WIN32
   #include <io.h>
#endif
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "abtvxt40.h"	/* Required Smalltalk VM Callin Header   */
#include "ioarea.h"	/* IOArea structure (record) definition  */

void errorRtn(void);

VAST_HANDLE vhandle;
VAST_STATUS vstatus;
VAST_RESULT vresult;

int main(int argc, char *argv[]){
	
   char imageName[64] = {0};     
   char receiver[64]  = {0};    
   char selector[64]  = {0};    
   long bufferLength  = 50;
   struct ioarea buffer = {"","","12/05/1976"};
   int std_out;

   #ifdef ABT_WIN32
      std_out = _dup(1);
   #else
      std_out = dup(1);
   #endif

 /********************************************************************/
 /*  Initialize required Smalltalk VM Callin parameters              */
 /********************************************************************/
   strcpy(imageName,"CALLINXX.icx");
   strcpy(receiver,"TestCallinApp");
   strcpy(selector,"run");

 /********************************************************************/
 /*  Smalltalk VM Startup                                            */
 /********************************************************************/
   vastart(imageName,&vhandle,&vstatus);
   printf("\n>  vastart() -> Smalltalk VM startup executed\n");
   printf(">     vhandle = %d\n",vhandle);
   if (vstatus != 0 || vhandle ==0 ) 
      errorRtn();

 /********************************************************************/
 /*  Smalltalk VM Run Image                                          */
 /********************************************************************/
   varun(&vhandle,receiver,selector,bufferLength,&buffer,
      &vstatus,&vresult);
   printf("\n>  varun() -> Smalltalk VM run image executed\n");
   printf(">     vresult = %d\n",vresult);
   if (vstatus != 0)
      errorRtn();
 
 /********************************************************************/
 /*  Obtain return infromation                                       */
 /********************************************************************/
   printf(">  The following data was returned by the callee\n");
   printf(">     IOArea [param1] = %s\n",buffer.param1);
   printf(">     IOArea [param2] = %s\n",buffer.param2);
   printf(">     IOArea [param3] = %s\n",buffer.param3);

 /********************************************************************/
 /*  Smalltalk VM Stop                                               */
 /*  Note: vastop() closes stdout!!!                                 */
 /********************************************************************/
   vastop(&vhandle,&vstatus);
   #ifdef ABT_WIN32
      _dup2(std_out,1);
   #else
      dup2(std_out,1);
   #endif   
   printf(">  vastop() -> Smalltalk VM stop executed\n");
   if (vstatus != 0)
      errorRtn();

   return(vstatus);
}

void errorRtn(){
   printf("Error - VSTATUS = %d\n",vstatus);
   exit(vstatus);
}
