package com.ibm.ulc.examples.pieExtension;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import com.ibm.ulc.ui.UIComponent;
import javax.swing.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.*;
/**
 * An example implementation of a piechart component.
 * The purpose of this widget is purely to demonstrate how a java bean
 * can be wrapped as a ULC component and installed as an extension
 * to the UI Engine. 
 *
 * @see PieChart
 * 	which implements the Pie java bean
 * @see ULCPieChart	
 *		which provides the ULC developer with an API to use this extension.
 */

public class UIPieChart extends UIComponent implements ActionListener {
	/**
	 * @serial
	 */
	private PieChart fPieChart = null;
/**
 * The PieChart bean has indicated that the user has triggered an action event.
 * Send this event to the ULC application.
 */

public void actionPerformed(ActionEvent e) {
	sendEventULC("action", "cmd", new Anything(e.getActionCommand()));
}
/**
 * The UI engine will call this method when there are no further references to this widget.
 * Perform any cleanup necessary.
 */
public void free() {
	if (fPieChart != null) {
		fPieChart.removeActionListener(this);
		fPieChart = null;
	}
	super.free();
}
/**
 * Return the Java widget that is added to my parent hierarchy.
 * In some cases eg: Table, List etc the component returned is a scrollpane which
 * contains the actual implementation widget. In that case you must implement
 * <code>getBasicComponent</code> that returns the implementation widget and
 * <code>getComponent</code> which returns the top level container that will be
 * added to this widgets parent hierarchy.
 */
public Component getComponent() {
	return fPieChart;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setData")) {
		setData(args);
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	fPieChart = new PieChart(args.get("w", 200), args.get("h", 150));
	super.restoreState(conn, args);
	fPieChart.addActionListener(this);
	setData(args.get("data"));
}
/**
 * Data has been sent from the application to the UI.
 * Extract the data from the data structure and update my widget.
 *
 * @param data 		the <code>Anything</code> that contains the data
 */
private void setData(Anything data) {
	Anything acolors = data.get("colors");
	Anything alabels = data.get("labels");
	Anything avalues = data.get("values");
	int cols = avalues.size();
	String colors[] = new String[cols];
	double values[] = new double[cols];
	String labels[] = new String[cols];
	for (int i = 0; i < cols; i++)
		colors[i] = acolors.get(i).asString("black");
	for (int i = 0; i < cols; i++)
		labels[i] = alabels.get(i).asString("no label");
	for (int i = 0; i < cols; i++)
		values[i] = avalues.get(i).asDouble(0.0);
	fPieChart.setData(labels, values, colors);
}
}
